/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.service.http.impl.netty;

import com.mulesoft.service.http.impl.netty.NettyOutboundWebSocket;
import com.mulesoft.service.http.impl.netty.NettyOutboundWebSocketReconnectionHandler;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.websocketx.WebSocketClientHandshakeException;
import io.netty.handler.ssl.SslContext;
import java.net.URI;
import java.time.Duration;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeoutException;
import org.mule.runtime.api.util.MultiMap;
import org.mule.runtime.http.api.client.HttpRequestOptions;
import org.mule.runtime.http.api.client.ws.WebSocketCallback;
import org.mule.runtime.http.api.domain.message.request.HttpRequest;
import org.mule.runtime.http.api.exception.InvalidStatusCodeException;
import org.mule.runtime.http.api.ws.WebSocket;
import org.mule.service.http.netty.impl.client.WebSocketsProvider;
import org.mule.service.http.netty.impl.util.HttpUtils;
import reactor.core.publisher.Mono;
import reactor.netty.NettyInbound;
import reactor.netty.NettyOutbound;
import reactor.netty.http.client.HttpClient;
import reactor.netty.http.websocket.WebsocketInbound;
import reactor.netty.http.websocket.WebsocketOutbound;
import reactor.netty.tcp.SslProvider;

public class NettyOutboundWebSocketsProvider
implements WebSocketsProvider {
    public CompletableFuture<WebSocket> openWebSocket(HttpRequest request, HttpRequestOptions requestOptions, String socketId, WebSocketCallback callback, SslContext sslContext) {
        CompletableFuture<WebSocket> future = new CompletableFuture<WebSocket>();
        String uri = HttpUtils.buildUriString((URI)request.getUri(), (MultiMap)request.getQueryParams());
        HttpClient httpClient = HttpClient.create();
        if (sslContext != null) {
            httpClient = httpClient.secure(SslProvider.builder().sslContext(sslContext).build());
        }
        httpClient = httpClient.followRedirect(requestOptions.isFollowsRedirect());
        Mono handshakeMono = ((HttpClient.WebsocketSender)httpClient.headers(upgradeRequestHeaders -> {
            for (String headerName : request.getHeaderNames()) {
                upgradeRequestHeaders.add(headerName, (Iterable)request.getHeaderValues(headerName));
            }
        }).websocket().uri(uri)).connect().timeout(Duration.ofMillis(requestOptions.getResponseTimeout())).doOnSuccess(connection -> {
            try {
                NettyInbound inbound = connection.inbound();
                NettyOutbound outbound = connection.outbound();
                NettyOutboundWebSocketReconnectionHandler reconnectionHandler = new NettyOutboundWebSocketReconnectionHandler(this, request, requestOptions, socketId, callback, sslContext);
                NettyOutboundWebSocket webSocket = new NettyOutboundWebSocket((WebsocketInbound)inbound, (WebsocketOutbound)outbound, socketId, new URI(uri), callback, reconnectionHandler, sslContext);
                callback.onConnect((WebSocket)webSocket);
                future.complete(webSocket);
            }
            catch (Exception e) {
                future.completeExceptionally(e);
            }
        }).doOnError(throwable -> {
            if (!future.isDone()) {
                if (throwable instanceof TimeoutException) {
                    future.completeExceptionally(new TimeoutException("WebSocket handshake timed out"));
                } else if (throwable instanceof WebSocketClientHandshakeException) {
                    HttpResponseStatus status = ((WebSocketClientHandshakeException)throwable).response().status();
                    future.completeExceptionally((Throwable)new InvalidStatusCodeException(status.code()));
                } else {
                    future.completeExceptionally((Throwable)throwable);
                }
            }
        }).then(Mono.never());
        handshakeMono.subscribe();
        return future;
    }
}

