/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.modules.configuration.properties.api;

import com.mulesoft.modules.configuration.properties.api.EncryptionAlgorithm;
import com.mulesoft.modules.configuration.properties.api.EncryptionMode;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.Optional;
import java.util.Set;
import org.mule.metadata.api.ClassTypeLoader;
import org.mule.metadata.api.builder.BaseTypeBuilder;
import org.mule.metadata.api.model.MetadataFormat;
import org.mule.metadata.api.model.MetadataType;
import org.mule.runtime.api.meta.Category;
import org.mule.runtime.api.meta.ExpressionSupport;
import org.mule.runtime.api.meta.model.declaration.fluent.ConfigurationDeclarer;
import org.mule.runtime.api.meta.model.declaration.fluent.ExtensionDeclarer;
import org.mule.runtime.api.meta.model.declaration.fluent.OptionalParameterDeclarer;
import org.mule.runtime.api.meta.model.declaration.fluent.ParameterGroupDeclarer;
import org.mule.runtime.api.meta.model.display.DisplayModel;
import org.mule.runtime.api.meta.model.display.PathModel;
import org.mule.runtime.extension.api.declaration.type.ExtensionsTypeLoaderFactory;
import org.mule.runtime.extension.api.loader.ExtensionLoadingContext;
import org.mule.runtime.extension.api.loader.ExtensionLoadingDelegate;

public class SecureConfigPropertiesExtensionLoadingDelegate
implements ExtensionLoadingDelegate {
    public static final String EXTENSION_NAME = "Secure Properties";
    public static final String VERSION = "1.2.6";

    public void accept(ExtensionDeclarer extensionDeclarer, ExtensionLoadingContext context) {
        Optional<Method> supportingJavaVersionsMethod = Arrays.stream(extensionDeclarer.getClass().getMethods()).filter(method -> method.getName().equals("supportingJavaVersions")).filter(method -> Arrays.equals(method.getParameterTypes(), new Class[]{Set.class})).findFirst();
        if (supportingJavaVersionsMethod.isPresent()) {
            try {
                extensionDeclarer = (ExtensionDeclarer)supportingJavaVersionsMethod.get().invoke((Object)extensionDeclarer, new LinkedHashSet<String>(Arrays.asList("1.8", "11", "17")));
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw new RuntimeException("Failed to initialize the extension when trying to declare `supportingJavaVersions` for the extension.", e);
            }
        }
        ConfigurationDeclarer configurationDeclarer = extensionDeclarer.named(EXTENSION_NAME).describedAs("Crafted Config Properties Extension").withCategory(Category.SELECT).onVersion(VERSION).fromVendor("Mulesoft").withConfig("config");
        ParameterGroupDeclarer defaultParameterGroup = configurationDeclarer.onDefaultParameterGroup();
        defaultParameterGroup.withRequiredParameter("file").ofType((MetadataType)BaseTypeBuilder.create((MetadataFormat)MetadataFormat.JAVA).stringType().build()).withExpressionSupport(ExpressionSupport.NOT_SUPPORTED).withDisplayModel(DisplayModel.builder().path(new PathModel(PathModel.Type.FILE, false, PathModel.Location.EMBEDDED, new String[]{"yaml", "properties"})).build()).describedAs(" The location of the file with the secure configuration properties to use. It may be a location in the classpath or an absolute location. \nThe file location value may also contains references to properties that will only be resolved based on system properties or properties set at deployment time.");
        defaultParameterGroup.withRequiredParameter("key").ofType((MetadataType)BaseTypeBuilder.create((MetadataFormat)MetadataFormat.JAVA).stringType().build());
        ((OptionalParameterDeclarer)defaultParameterGroup.withOptionalParameter("fileLevelEncryption").ofType((MetadataType)BaseTypeBuilder.create((MetadataFormat)MetadataFormat.JAVA).booleanType().build())).defaultingTo((Object)Boolean.FALSE);
        defaultParameterGroup.withOptionalParameter("encoding").ofType((MetadataType)BaseTypeBuilder.create((MetadataFormat)MetadataFormat.JAVA).stringType().build());
        ParameterGroupDeclarer parameterGroupDeclarer = configurationDeclarer.onParameterGroup("encrypt").withDslInlineRepresentation(true);
        ClassTypeLoader typeLoader = ExtensionsTypeLoaderFactory.getDefault().createTypeLoader();
        ((OptionalParameterDeclarer)parameterGroupDeclarer.withOptionalParameter("algorithm").ofType(typeLoader.load(EncryptionAlgorithm.class))).defaultingTo((Object)EncryptionAlgorithm.AES);
        ((OptionalParameterDeclarer)parameterGroupDeclarer.withOptionalParameter("mode").ofType(typeLoader.load(EncryptionMode.class))).defaultingTo((Object)EncryptionMode.CBC);
        ((OptionalParameterDeclarer)((OptionalParameterDeclarer)((OptionalParameterDeclarer)parameterGroupDeclarer.withOptionalParameter("useRandomIVs").ofType((MetadataType)BaseTypeBuilder.create((MetadataFormat)MetadataFormat.JAVA).booleanType().build())).withDisplayModel(DisplayModel.builder().displayName("Use random IVs").summary("Use random initial vectors (IVs). In case of decryption, it assumes IV is prepended on the ciphertext.").build())).withExpressionSupport(ExpressionSupport.NOT_SUPPORTED)).defaultingTo((Object)Boolean.FALSE);
    }
}

