/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.modules.configuration.properties.internal.keyfactories;

import java.security.Key;
import java.security.KeyFactory;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import org.mule.encryption.key.EncryptionKeyFactory;
import org.mule.runtime.core.api.util.Base64;

public class AsymmetricEncryptionKeyFactory
implements EncryptionKeyFactory {
    private String algorithm;
    private String key;

    public AsymmetricEncryptionKeyFactory(String algorithm, String key) {
        this.algorithm = algorithm;
        this.key = key;
        this.validateKey();
    }

    public Key encryptionKey() {
        PKCS8EncodedKeySpec spec = new PKCS8EncodedKeySpec(Base64.decode((String)this.key));
        try {
            KeyFactory kf = KeyFactory.getInstance(this.algorithm);
            return kf.generatePrivate(spec);
        }
        catch (Exception e) {
            throw new RuntimeException("Could not build the Encryption key", e);
        }
    }

    public Key decryptionKey() {
        X509EncodedKeySpec spec = new X509EncodedKeySpec(Base64.decode((String)this.key));
        try {
            KeyFactory kf = KeyFactory.getInstance(this.algorithm);
            return kf.generatePublic(spec);
        }
        catch (Exception e) {
            throw new RuntimeException("Could not build the descryption key", e);
        }
    }

    private void validateKey() {
        if (this.key == null) {
            throw new IllegalArgumentException("If keystore is not defined then the key is considered to be an encryption key in Base64 encoding");
        }
    }
}

