/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.modules.oauth2.provider.api;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.mule.runtime.api.security.Authentication;
import org.mule.runtime.core.api.security.DefaultMuleCredentials;

public class ResourceOwnerAuthentication
implements Authentication {
    private static final long serialVersionUID = 7726405183870224981L;
    private String username;
    private Object principal;
    private Object credentials;
    private Set<String> roles;
    private Map<String, Object> properties;

    private ResourceOwnerAuthentication(Builder builder) {
        this.username = builder.username;
        this.principal = builder.principal;
        this.credentials = builder.credentials;
        this.roles = builder.roles;
        this.properties = builder.properties;
    }

    public ResourceOwnerAuthentication() {
    }

    public Object getCredentials() {
        return this.credentials;
    }

    public void setCredentials(Object credentials) {
        this.credentials = credentials;
    }

    public Object getPrincipal() {
        return this.principal;
    }

    public void setPrincipal(Object principal) {
        this.principal = principal;
    }

    public Map<String, Object> getProperties() {
        return this.properties;
    }

    public Authentication setProperties(Map<String, Object> properties) {
        return new Builder().withUsername(this.username).withPrincipal(this.principal).withCredentials(this.credentials).withRoles(this.roles).withProperties(properties).build();
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public Set<String> getRoles() {
        return this.roles;
    }

    public void setRoles(Set<String> roles) {
        this.roles = roles;
    }

    public static class Builder {
        private String username;
        private Object principal;
        private Object credentials;
        private Set<String> roles = new HashSet<String>();
        private Map<String, Object> properties = new HashMap<String, Object>();

        public Builder withUsername(String username) {
            this.username = username;
            if (this.principal == null) {
                this.principal = username;
            }
            return this;
        }

        public Builder withPrincipal(Object principal) {
            if (principal instanceof String) {
                return this.withPrincipal((String)principal);
            }
            this.principal = principal;
            return this;
        }

        private Builder withPrincipal(String principal) {
            this.principal = principal;
            if (this.username == null) {
                this.username = principal;
            }
            return this;
        }

        public Builder withCredentials(Object credentials) {
            if (credentials instanceof DefaultMuleCredentials) {
                return this.withCredentials((DefaultMuleCredentials)credentials);
            }
            this.credentials = credentials;
            return this;
        }

        private Builder withCredentials(DefaultMuleCredentials credentials) {
            this.credentials = credentials.getPassword();
            if (this.username == null) {
                this.withUsername(credentials.getUsername());
            }
            return this;
        }

        public Builder withRoles(Set<String> roles) {
            this.roles = roles;
            return this;
        }

        public Builder withProperties(Map<String, Object> properties) {
            this.properties = properties;
            return this;
        }

        public ResourceOwnerAuthentication build() {
            return new ResourceOwnerAuthentication(this);
        }
    }
}

