/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.modules.oauth2.provider.internal.token;

import com.mulesoft.modules.oauth2.provider.api.AuthorizationRequest;
import com.mulesoft.modules.oauth2.provider.api.Constants;
import com.mulesoft.modules.oauth2.provider.api.ResourceOwnerAuthentication;
import com.mulesoft.modules.oauth2.provider.api.token.AccessTokenStoreHolder;
import com.mulesoft.modules.oauth2.provider.api.token.Token;
import com.mulesoft.modules.oauth2.provider.api.token.TokenStore;
import com.mulesoft.modules.oauth2.provider.api.token.generator.RefreshTokenStrategy;
import com.mulesoft.modules.oauth2.provider.api.token.generator.TokenGeneratorStrategy;
import com.mulesoft.modules.oauth2.provider.internal.token.InvalidGrantException;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.mule.runtime.api.util.Preconditions;

public class TokenManager {
    private final TokenStore tokenStore;
    private final TokenGeneratorStrategy tokenGeneratorStrategy;
    private final RefreshTokenStrategy refreshTokenStrategy;
    private final long tokenExpirationInterval;
    private final TimeUnit tokenExpirationIntervalTimeUnit;

    public TokenManager(TokenStore tokenStore, TokenGeneratorStrategy tokenGeneratorStrategy, RefreshTokenStrategy refreshTokenStrategy, long tokenExpirationInterval, TimeUnit tokenExpirationIntervalTimeUnit) {
        Preconditions.checkArgument((tokenStore != null ? 1 : 0) != 0, (String)"tokenStore can't be null");
        Preconditions.checkArgument((tokenGeneratorStrategy != null ? 1 : 0) != 0, (String)"tokenGeneratorStrategy can't be null");
        Preconditions.checkArgument((tokenExpirationIntervalTimeUnit != null ? 1 : 0) != 0, (String)"token expiration interval time unit can't be null");
        this.tokenStore = tokenStore;
        this.tokenGeneratorStrategy = tokenGeneratorStrategy;
        this.refreshTokenStrategy = refreshTokenStrategy;
        this.tokenExpirationInterval = tokenExpirationInterval;
        this.tokenExpirationIntervalTimeUnit = tokenExpirationIntervalTimeUnit;
    }

    public Token grantAccessToken(Constants.RequestGrantType grantType, AuthorizationRequest authorizationRequest, ResourceOwnerAuthentication resourceOwnerAuthentication) {
        Preconditions.checkArgument((authorizationRequest != null ? 1 : 0) != 0, (String)"authorizationRequest can't be null");
        return this.grantAccessToken(grantType, authorizationRequest, authorizationRequest.getClientId(), authorizationRequest.getScopes(), resourceOwnerAuthentication);
    }

    public Token grantAccessToken(Constants.RequestGrantType grantType, String clientId, Set<String> scopes, ResourceOwnerAuthentication resourceOwnerAuthentication) {
        return this.grantAccessToken(grantType, null, clientId, scopes, resourceOwnerAuthentication);
    }

    private Token grantAccessToken(Constants.RequestGrantType grantType, AuthorizationRequest authorizationRequest, String clientId, Set<String> scopes, ResourceOwnerAuthentication resourceOwnerAuthentication) {
        Preconditions.checkArgument((grantType != null ? 1 : 0) != 0, (String)"grantType can't be null");
        Preconditions.checkArgument((!org.mule.runtime.core.api.util.StringUtils.isEmpty((String)clientId) ? 1 : 0) != 0, (String)"clientId can't be empty");
        Preconditions.checkArgument((scopes != null ? 1 : 0) != 0, (String)"scopes can't be null");
        String refreshToken = this.refreshTokenStrategy.generateRefreshToken();
        Token oauth2Token = new Token.Builder(clientId, this.tokenGeneratorStrategy.generateToken()).withRefreshToken(refreshToken).withScopes(scopes).withExpirationInterval(this.tokenExpirationInterval, this.tokenExpirationIntervalTimeUnit).build();
        ResourceOwnerAuthentication actualResourceOwnerAuthentication = resourceOwnerAuthentication == null && authorizationRequest != null ? authorizationRequest.getResourceOwnerAuthentication() : resourceOwnerAuthentication;
        this.tokenStore.store(new AccessTokenStoreHolder(oauth2Token, authorizationRequest, actualResourceOwnerAuthentication));
        return oauth2Token;
    }

    private Token refreshAccessToken(AccessTokenStoreHolder previousHolder) throws InvalidGrantException {
        Preconditions.checkArgument((previousHolder != null ? 1 : 0) != 0, (String)"previousHolder can't be null");
        if (this.tokenStore.remove(previousHolder.getAccessToken().getAccessToken()) == null) {
            throw new InvalidGrantException("Invalid refresh token");
        }
        Token previousToken = previousHolder.getAccessToken();
        String newAccessToken = this.tokenGeneratorStrategy.generateToken();
        String newRefreshToken = this.refreshTokenStrategy.exchangeRefreshToken(previousToken.getRefreshToken());
        Token.Builder builder = new Token.Builder(newAccessToken, previousToken).withRefreshToken(newRefreshToken);
        Token refreshedToken = builder.build();
        this.tokenStore.store(new AccessTokenStoreHolder(refreshedToken, previousHolder));
        return refreshedToken;
    }

    public AccessTokenStoreHolder getNonExpiredAccessTokenHolder(String accessToken) {
        if (StringUtils.isBlank((CharSequence)accessToken)) {
            return null;
        }
        AccessTokenStoreHolder holder = this.tokenStore.retrieveByAccessToken(accessToken);
        if (holder == null) {
            return null;
        }
        Token token = holder.getAccessToken();
        if (this.isTokenExpired(accessToken)) {
            if (!token.hasRefreshToken() || this.isTokenExpired(token.getRefreshToken())) {
                this.tokenStore.remove(holder.getAccessToken().getAccessToken());
            }
            return null;
        }
        return holder;
    }

    public Token exchangeRefreshToken(String refreshToken, String clientId) throws InvalidGrantException {
        Token currentAccessToken;
        AccessTokenStoreHolder holder = this.tokenStore.retrieveByRefreshToken(refreshToken);
        Token token = currentAccessToken = holder == null ? null : holder.getAccessToken();
        if (currentAccessToken != null && this.isTokenExpired(currentAccessToken.getRefreshToken())) {
            this.tokenStore.removeByRefreshToken(refreshToken);
        }
        if (currentAccessToken == null || this.isTokenExpired(currentAccessToken.getRefreshToken()) || !currentAccessToken.getClientId().equals(clientId)) {
            throw new InvalidGrantException("Invalid or expired refresh token");
        }
        return this.refreshAccessToken(holder);
    }

    public boolean isTokenExpired(String token) {
        AccessTokenStoreHolder tokenHolder = this.tokenStore.retrieveByAccessToken(token);
        if (tokenHolder != null) {
            if (!tokenHolder.getAccessToken().hasRefreshToken()) {
                return false;
            }
            return this.isTokenExpired(tokenHolder.getAccessToken().getRefreshToken());
        }
        tokenHolder = this.tokenStore.retrieveByRefreshToken(token);
        return tokenHolder == null;
    }
}

