/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.modules.oauth2.provider.internal.processor;

import com.mulesoft.modules.oauth2.provider.api.Constants;
import com.mulesoft.modules.oauth2.provider.api.ResourceOwnerAuthentication;
import com.mulesoft.modules.oauth2.provider.api.client.Client;
import com.mulesoft.modules.oauth2.provider.api.client.NoSuchClientException;
import com.mulesoft.modules.oauth2.provider.api.ratelimit.RateLimiter;
import com.mulesoft.modules.oauth2.provider.internal.Utils;
import com.mulesoft.modules.oauth2.provider.internal.config.OAuthConfiguration;
import com.mulesoft.modules.oauth2.provider.internal.processor.ClientSecretCredentials;
import com.mulesoft.modules.oauth2.provider.internal.processor.OAuth2ProviderProcessor;
import com.mulesoft.modules.oauth2.provider.internal.processor.RequestData;
import com.mulesoft.modules.oauth2.provider.internal.processor.RequestProcessingException;
import com.mulesoft.modules.oauth2.provider.internal.processor.RequestProcessingExceptionFactory;
import com.mulesoft.modules.oauth2.provider.internal.ratelimit.RateLimitExceededException;
import com.mulesoft.modules.oauth2.provider.internal.token.InvalidGrantException;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.security.Authentication;
import org.mule.runtime.api.security.Credentials;
import org.mule.runtime.api.security.DefaultMuleAuthentication;
import org.mule.runtime.api.security.SecurityException;
import org.mule.runtime.api.util.MultiMap;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.core.api.security.DefaultMuleCredentials;
import org.mule.runtime.core.api.util.ExceptionUtils;
import org.mule.runtime.http.api.HttpConstants;
import org.mule.runtime.http.api.HttpHeaders;
import org.mule.runtime.http.api.domain.entity.ByteArrayHttpEntity;
import org.mule.runtime.http.api.domain.entity.EmptyHttpEntity;
import org.mule.runtime.http.api.domain.entity.HttpEntity;
import org.mule.runtime.http.api.domain.message.response.HttpResponseBuilder;
import org.mule.runtime.http.api.domain.request.HttpRequestContext;
import org.mule.runtime.http.api.utils.HttpEncoderDecoderUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OAuth2ProviderRequestProcessor {
    private static final Logger LOGGER = LoggerFactory.getLogger(OAuth2ProviderRequestProcessor.class);
    protected OAuthConfiguration configuration;

    public OAuth2ProviderRequestProcessor(OAuthConfiguration configuration) {
        this.configuration = configuration;
    }

    public final void process(HttpRequestContext httpRequestContext, HttpResponseBuilder httpResponseBuilder, OAuth2ProviderProcessor oAuth2ProviderProcessor) {
        RequestData requestData = null;
        try {
            requestData = new RequestData(httpRequestContext);
            oAuth2ProviderProcessor.process(requestData, httpResponseBuilder);
        }
        catch (RequestProcessingException rpe) {
            this.handleException(rpe, requestData, httpResponseBuilder);
        }
        catch (Exception e) {
            this.handleException(this.convertToRequestProcessingException(e), requestData, httpResponseBuilder);
        }
    }

    protected RequestProcessingException convertToRequestProcessingException(Exception e) {
        if (e instanceof InvalidGrantException) {
            return new RequestProcessingException(RequestProcessingException.ErrorType.INVALID_GRANT, e.getMessage());
        }
        if (e instanceof NoSuchClientException) {
            return new RequestProcessingException(RequestProcessingException.ErrorType.UNAUTHORIZED_CLIENT, "Invalid client");
        }
        if (e instanceof RateLimitExceededException) {
            return new RequestProcessingException(RequestProcessingException.ErrorType.RATE_LIMIT_EXCEEDED);
        }
        Throwable requestProcessingException = ExceptionUtils.extractCauseOfType((Throwable)e, RequestProcessingException.class).orElse(null);
        if (requestProcessingException != null) {
            return (RequestProcessingException)((Object)requestProcessingException);
        }
        Throwable illegalArgumentException = ExceptionUtils.extractCauseOfType((Throwable)e, IllegalArgumentException.class).orElse(null);
        if (illegalArgumentException != null) {
            return new RequestProcessingException(RequestProcessingException.ErrorType.INVALID_REQUEST, illegalArgumentException.getMessage());
        }
        return new RequestProcessingException(RequestProcessingException.ErrorType.SERVER_ERROR, (Throwable)e);
    }

    protected void handleException(RequestProcessingException exception, RequestData requestData, HttpResponseBuilder httpResponseBuilder) {
        if (exception.getErrorType() == RequestProcessingException.ErrorType.SERVER_ERROR) {
            LOGGER.error("Unexpected exception", (Throwable)((Object)exception));
            httpResponseBuilder.statusCode(Integer.valueOf(HttpConstants.HttpStatus.INTERNAL_SERVER_ERROR.getStatusCode()));
            httpResponseBuilder.reasonPhrase("SERVER ERROR");
            this.setResponsePayload(httpResponseBuilder, Utils.resolveMessageEncoding(requestData).name(), "error", RequestProcessingException.ErrorType.SERVER_ERROR.getErrorCode());
            return;
        }
        if (exception.getErrorType() == RequestProcessingException.ErrorType.RATE_LIMIT_EXCEEDED) {
            httpResponseBuilder.statusCode(Integer.valueOf(HttpConstants.HttpStatus.TOO_MANY_REQUESTS.getStatusCode()));
            httpResponseBuilder.entity((HttpEntity)new EmptyHttpEntity());
            return;
        }
        String[] parameters = new String[]{"error", exception.getErrorType().getErrorCode(), "error_description", exception.getMessage()};
        String redirectUri = this.getParameterFromBodyOrQuery(requestData, "redirect_uri");
        boolean redirectedForError = false;
        if (this.isRedirectingForError(exception.getErrorType(), redirectUri)) {
            try {
                try {
                    this.getSupportedResponseTypeOrFail(requestData);
                }
                catch (RequestProcessingException requestProcessingException) {
                    // empty catch block
                }
                String actualRedirectUri = this.buildErrorResponseRedirectUri(redirectUri, requestData, parameters);
                this.setRedirectResponse(httpResponseBuilder, actualRedirectUri);
                redirectedForError = true;
            }
            catch (RequestProcessingException requestProcessingException) {
                // empty catch block
            }
        }
        if (!redirectedForError) {
            httpResponseBuilder.statusCode(Integer.valueOf(HttpConstants.HttpStatus.BAD_REQUEST.getStatusCode()));
            this.setResponsePayload(httpResponseBuilder, Utils.resolveMessageEncoding(requestData).name(), parameters);
        }
    }

    protected boolean isRedirectingForError(RequestProcessingException.ErrorType errorType, String redirectUri) {
        return errorType.isDoRedirect() && StringUtils.isNotBlank((CharSequence)redirectUri);
    }

    protected void setResponsePayload(HttpResponseBuilder responseBuilder, String encoding, String ... parameters) {
        responseBuilder.entity((HttpEntity)new ByteArrayHttpEntity(this.buildEncodedParameters(encoding, parameters).getBytes()));
        responseBuilder.addHeader("Content-Type", HttpHeaders.Values.APPLICATION_X_WWW_FORM_URLENCODED.toRfcString());
    }

    protected void setRedirectResponse(HttpResponseBuilder httpResponseBuilder, String actualRedirectUri) {
        httpResponseBuilder.statusCode(Integer.valueOf(HttpConstants.HttpStatus.MOVED_TEMPORARILY.getStatusCode()));
        httpResponseBuilder.addHeader("Content-Type", HttpHeaders.Values.APPLICATION_X_WWW_FORM_URLENCODED.toRfcString());
        httpResponseBuilder.addHeader("Location", actualRedirectUri);
    }

    protected String buildErrorResponseRedirectUri(String redirectUri, RequestData requestData, String ... parameters) throws RequestProcessingException {
        try {
            return this.buildRedirectUri(redirectUri, requestData, parameters);
        }
        catch (RequestProcessingException e) {
            return this.buildRedirectUri(redirectUri, requestData, false, parameters);
        }
    }

    protected String buildRedirectUri(String redirectUri, RequestData requestData, String ... parameters) throws RequestProcessingException {
        Constants.ResponseType responseType = this.getSupportedResponseTypeOrFail(requestData);
        boolean parametersInFragment = responseType == Constants.ResponseType.TOKEN;
        return this.buildRedirectUri(redirectUri, requestData, parametersInFragment, parameters);
    }

    private String buildRedirectUri(String redirectUri, RequestData requestData, boolean parametersInFragment, String ... parameters) throws RequestProcessingException {
        String state = this.getOptionalParameter(requestData, "state");
        String encoding = Utils.resolveMessageEncoding(requestData).name();
        if (StringUtils.isNotBlank((CharSequence)state)) {
            return this.buildRedirectUri(redirectUri, encoding, parametersInFragment, (String[])ArrayUtils.addAll((Object[])parameters, (Object[])new String[]{"state", state}));
        }
        return this.buildRedirectUri(redirectUri, encoding, parametersInFragment, parameters);
    }

    public String buildRedirectUri(String redirectUri, String encoding, boolean parametersInFragment, String ... parameters) throws RequestProcessingException {
        String encodedParameters = this.buildEncodedParameters(encoding, parameters);
        URI uri = this.newURI(redirectUri);
        String noFragmentRedirectUri = this.stripFragment(uri);
        if (StringUtils.isBlank((CharSequence)encodedParameters)) {
            return noFragmentRedirectUri;
        }
        String parametersSeparator = parametersInFragment ? "#" : (this.hasQuery(uri) ? "&" : "?");
        return noFragmentRedirectUri + parametersSeparator + encodedParameters;
    }

    private boolean hasQuery(URI uri) {
        return StringUtils.isNotBlank((CharSequence)uri.getQuery());
    }

    protected Map<String, Object> keyValuePairsToMap(Object ... parameters) {
        Preconditions.checkArgument((parameters.length % 2 == 0 ? 1 : 0) != 0, (String)"need an even number of (param name, param value) string pairs");
        HashMap<String, Object> result = new HashMap<String, Object>();
        for (int i = 0; i < parameters.length; i += 2) {
            Object value = parameters[i + 1];
            if (value == null) continue;
            String key = (String)parameters[i];
            result.put(key, value);
        }
        return result;
    }

    private String buildEncodedParameters(String encoding, String ... parameters) {
        Preconditions.checkArgument((parameters.length % 2 == 0 ? 1 : 0) != 0, (String)"need an even number of (param name, param value) string pairs");
        StringBuilder parametersBuilder = new StringBuilder();
        for (int i = 0; i < parameters.length; i += 2) {
            String name = parameters[i];
            String value = parameters[i + 1];
            if (!StringUtils.isNotBlank((CharSequence)value)) continue;
            if (parametersBuilder.length() > 0) {
                parametersBuilder.append('&');
            }
            parametersBuilder.append(name).append('=').append(this.urlEncode(value, encoding));
        }
        return parametersBuilder.toString();
    }

    protected String getMandatoryParameterOrFail(RequestData requestData, String parameterName) throws RequestProcessingException {
        String parameterValue = this.getOptionalParameter(requestData, parameterName);
        if (StringUtils.isBlank((CharSequence)parameterValue)) {
            RequestProcessingException.ErrorType errorType = RequestProcessingException.ErrorType.findByParameterName(parameterName);
            if (errorType == null) {
                errorType = RequestProcessingException.ErrorType.INVALID_REQUEST;
            }
            throw new RequestProcessingException(errorType, "Missing mandatory parameter: " + parameterName);
        }
        return parameterValue;
    }

    protected String getOptionalParameter(RequestData requestData, String parameterName) {
        String parameterValue = this.getParameterFromBodyOrQuery(requestData, parameterName);
        if (StringUtils.isBlank((CharSequence)parameterValue)) {
            return null;
        }
        return parameterValue;
    }

    protected Constants.ResponseType getSupportedResponseTypeOrFail(RequestData requestData) throws RequestProcessingException {
        String responseTypeString = this.getMandatoryParameterOrFail(requestData, "response_type");
        try {
            Constants.ResponseType responseType = Constants.ResponseType.valueOfIgnoreCase(responseTypeString);
            if (!this.configuration.isAuthorizationResponseTypeSupported(responseType)) {
                throw new RequestProcessingException(RequestProcessingException.ErrorType.UNSUPPORTED_RESPONSE_TYPE, this.buildUnsupportedResponseTypeErrorMessage(responseTypeString));
            }
            return responseType;
        }
        catch (IllegalArgumentException iae) {
            throw new RequestProcessingException(RequestProcessingException.ErrorType.UNSUPPORTED_RESPONSE_TYPE, this.buildUnsupportedResponseTypeErrorMessage(responseTypeString));
        }
    }

    private String buildUnsupportedResponseTypeErrorMessage(String responseTypeString) {
        return "Response type '" + responseTypeString + "' is not supported";
    }

    protected Constants.RequestGrantType getSupportedRequestGrantTypeOrFail(RequestData requestData) throws RequestProcessingException {
        String grantType = this.getMandatoryParameterOrFail(requestData, "grant_type");
        try {
            Constants.RequestGrantType requestGrantType = Constants.RequestGrantType.valueOfIgnoreCase(grantType);
            if (!this.configuration.isRequestGrantTypeSupported(requestGrantType)) {
                throw new RequestProcessingException(RequestProcessingException.ErrorType.UNSUPPORTED_GRANT_TYPE, this.buildUnsupportedRequestGrantTypeErrorMessage(grantType));
            }
            return requestGrantType;
        }
        catch (IllegalArgumentException iae) {
            throw new RequestProcessingException(RequestProcessingException.ErrorType.UNSUPPORTED_GRANT_TYPE, this.buildUnsupportedRequestGrantTypeErrorMessage(grantType));
        }
    }

    private String buildUnsupportedRequestGrantTypeErrorMessage(String grantType) {
        return "Grant type '" + grantType + "' is not supported";
    }

    protected Client getKnownClientOrFail(RequestData requestData) throws SecurityException {
        Credentials credentials = this.extractClientCredentials(requestData);
        String clientId = credentials.getUsername();
        return this.configuration.getClientManager().getClientById(clientId);
    }

    protected String getValidRedirectionUriOrFail(Client client, RequestData requestData) throws RequestProcessingException {
        String redirectUri = this.getMandatoryParameterOrFail(requestData, "redirect_uri");
        if (!client.isValidRedirectUri(redirectUri)) {
            throw new RequestProcessingException(RequestProcessingException.ErrorType.INVALID_REDIRECTION_URI);
        }
        return redirectUri;
    }

    private String getParameterFromBodyOrQuery(RequestData requestData, String parameterName) {
        MultiMap parameters;
        String parameterValue = null;
        List parameterRawValue = null;
        String requestContentType = requestData.getContext().getRequest().getHeaderValueIgnoreCase("Content-Type");
        if (requestContentType != null && requestContentType.contains(HttpHeaders.Values.APPLICATION_X_WWW_FORM_URLENCODED.withoutParameters().toRfcString()) && !(parameterRawValue = (parameters = HttpEncoderDecoderUtils.decodeUrlEncodedBody((String)requestData.getContent(), (Charset)Utils.resolveMessageEncoding(requestData))).entrySet().stream().filter(entry -> StringUtils.equalsIgnoreCase((CharSequence)((CharSequence)entry.getKey()), (CharSequence)parameterName)).map(Map.Entry::getValue).collect(Collectors.toList())).isEmpty()) {
            parameterValue = this.getSingleParameterValue(parameterRawValue);
        }
        if (StringUtils.isBlank(parameterValue)) {
            parameterValue = this.getSingleParameterValue(requestData.getContext().getRequest().getQueryParams().getAll((Object)parameterName));
        }
        if (StringUtils.isBlank(parameterValue)) {
            parameterValue = requestData.getContext().getRequest().getHeaderValueIgnoreCase(parameterName);
        }
        return StringUtils.stripToNull(parameterValue);
    }

    private String getSingleParameterValue(Object values) {
        if (values == null) {
            return null;
        }
        if (values instanceof String) {
            return (String)values;
        }
        if (values instanceof List) {
            return StringUtils.join(new HashSet((List)values), (char)' ');
        }
        if (values.getClass().isArray()) {
            return StringUtils.join(new HashSet<Object>(Arrays.asList((Object[])values)), (char)' ');
        }
        return values.toString();
    }

    private String urlEncode(String value, String encoding) {
        try {
            return URLEncoder.encode(value, encoding);
        }
        catch (UnsupportedEncodingException uee) {
            throw new MuleRuntimeException((Throwable)uee);
        }
    }

    private String urlDecode(String value, String encoding) {
        try {
            return URLDecoder.decode(value, encoding);
        }
        catch (UnsupportedEncodingException uee) {
            throw new MuleRuntimeException((Throwable)uee);
        }
    }

    private URI newURI(String uri) throws RequestProcessingException {
        try {
            return new URI(uri);
        }
        catch (URISyntaxException urie) {
            throw new RequestProcessingException(RequestProcessingException.ErrorType.INVALID_REDIRECTION_URI, urie.getMessage());
        }
    }

    private String stripFragment(URI uri) {
        String fragment = uri.getFragment();
        if (StringUtils.isNotBlank((CharSequence)fragment)) {
            return StringUtils.substringBefore((String)uri.toString(), (String)("#" + fragment));
        }
        return uri.toString();
    }

    protected Credentials extractResourceOwnerCredentials(RequestData requestData) throws RequestProcessingException {
        String username = this.getMandatoryParameterOrFail(requestData, "username");
        String password = StringUtils.stripToEmpty((String)this.getOptionalParameter(requestData, "password"));
        return new DefaultMuleCredentials(username, password.toCharArray());
    }

    protected Credentials extractClientCredentials(RequestData requestData) throws RequestProcessingException {
        String clientId = this.getOptionalParameter(requestData, "client_id");
        String clientSecret = StringUtils.stripToEmpty((String)this.getOptionalParameter(requestData, "client_secret"));
        String basicAuthHeader = this.getOptionalParameter(requestData, "Authorization");
        if (StringUtils.isBlank((CharSequence)basicAuthHeader)) {
            basicAuthHeader = requestData.getContext().getRequest().getHeaderValueIgnoreCase("Authorization");
        }
        if (StringUtils.isBlank((CharSequence)clientId) && StringUtils.isBlank((CharSequence)basicAuthHeader)) {
            throw RequestProcessingExceptionFactory.noClientAuthenticationException();
        }
        if (StringUtils.isNotBlank((CharSequence)clientSecret) && StringUtils.isNotBlank((CharSequence)basicAuthHeader)) {
            throw new RequestProcessingException(RequestProcessingException.ErrorType.INVALID_REQUEST, "Multiple client authentications found");
        }
        if (StringUtils.isBlank((CharSequence)basicAuthHeader)) {
            return new ClientSecretCredentials(clientId, clientSecret.toCharArray());
        }
        Pair<String, String> idAndSecret = this.getBasicAuthClientIdAndSecret(requestData);
        clientId = (String)idAndSecret.getLeft();
        clientSecret = (String)idAndSecret.getRight();
        if (StringUtils.isBlank((CharSequence)clientId)) {
            throw new RequestProcessingException(RequestProcessingException.ErrorType.INVALID_REQUEST, "Invalid 'Authorization' header");
        }
        return new ClientSecretCredentials(clientId, clientSecret.toCharArray());
    }

    private Pair<String, String> getBasicAuthClientIdAndSecret(RequestData requestData) {
        String basicAuthHeader = requestData.getContext().getRequest().getHeaderValueIgnoreCase("Authorization");
        String decodedBasicAuthHeader = Utils.extractCredentialsFromAuthorizationHeader(basicAuthHeader, "Basic", Utils.resolveMessageEncoding(requestData).name());
        String clientId = Utils.urlDecode(StringUtils.substringBefore((String)decodedBasicAuthHeader, (String)":"));
        String clientSecret = StringUtils.stripToEmpty((String)Utils.urlDecode(StringUtils.substringAfter((String)decodedBasicAuthHeader, (String)":")));
        return Pair.of((Object)clientId, (Object)clientSecret);
    }

    protected Set<String> getEffectiveScopes(RequestData requestData, Client client) throws RequestProcessingException {
        Set<String> requestedScopes = Utils.tokenize(this.getOptionalParameter(requestData, "scope"), " ");
        Set<String> clientScopes = client.getScopes();
        if (clientScopes.isEmpty() && !this.configuration.getDefaultScopes().isEmpty()) {
            clientScopes = this.configuration.getDefaultScopes();
        }
        return Utils.computeEffectiveScopeOrFail(requestedScopes, clientScopes, this.configuration.getSupportedScopes());
    }

    protected Pair<Boolean, ResourceOwnerAuthentication> validateResourceOwnerCredentials(Client client, RequestData requestData) throws SecurityException {
        ResourceOwnerAuthentication authentication = null;
        Credentials credentials = this.extractResourceOwnerCredentials(requestData);
        this.configuration.getRateLimiter().checkOperationAuthorized(RateLimiter.Operation.RESOURCE_OWNER_LOGIN, credentials.getUsername());
        try {
            authentication = this.configuration.getResourceOwnerSecurityProvider().authenticate((Authentication)new DefaultMuleAuthentication(credentials));
        }
        catch (Exception e) {
            this.logValidationException(client, credentials, e);
        }
        boolean success = false;
        if (authentication != null) {
            success = true;
        }
        this.configuration.getRateLimiter().recordOperationOutcome(RateLimiter.Operation.RESOURCE_OWNER_LOGIN, credentials.getUsername(), success ? RateLimiter.Outcome.SUCCESS : RateLimiter.Outcome.FAILURE);
        return Pair.of((Object)success, (Object)authentication);
    }

    private void logValidationException(Client client, Credentials credentials, Exception e) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.warn(this.getValidationMessage(client, credentials), (Throwable)e);
        } else {
            LOGGER.warn(this.getValidationMessage(client, credentials));
        }
    }

    private String getValidationMessage(Client client, Credentials credentials) {
        return String.format("Failed to validate client credentials for client ID: %s and principal: %s", client.getClientId(), credentials.getUsername());
    }

    protected boolean validateClientCredentials(Client client, RequestData requestData) throws RequestProcessingException {
        Credentials credentials = this.extractClientCredentials(requestData);
        boolean validated = client.isAuthenticatedBy((ClientSecretCredentials)credentials);
        if (validated) {
            return true;
        }
        if (this.configuration.getClientSecurityProvider() == null) {
            LOGGER.warn("Client ID: " + client.getClientId() + " failed to present a secret and no security provider is configured to validate its credentials");
            return false;
        }
        String effectivePrincipal = StringUtils.isNotBlank((CharSequence)client.getPrincipal()) ? client.getPrincipal() : credentials.getUsername();
        DefaultMuleCredentials effectiveCredentials = new DefaultMuleCredentials(effectivePrincipal, credentials.getPassword());
        try {
            this.configuration.getClientSecurityProvider().authenticate((Authentication)new DefaultMuleAuthentication((Credentials)effectiveCredentials));
            return true;
        }
        catch (Exception e) {
            this.logValidationException(client, (Credentials)effectiveCredentials, e);
            return false;
        }
    }

    protected void failIfParameterPresentMultipleTimes(RequestData requestData, String ... parameterNames) throws RequestProcessingException {
        for (String parameterName : parameterNames) {
            List asBody = HttpEncoderDecoderUtils.decodeUrlEncodedBody((String)requestData.getContent(), (Charset)Utils.resolveMessageEncoding(requestData)).getAll((Object)parameterName);
            Collection asHeader = requestData.getContext().getRequest().getHeaderValuesIgnoreCase(parameterName);
            List asQueryParam = requestData.getContext().getRequest().getQueryParams().getAll((Object)parameterName);
            if (asBody.size() + asHeader.size() + asQueryParam.size() <= 1) continue;
            throw new RequestProcessingException(RequestProcessingException.ErrorType.INVALID_REQUEST, String.format("Found multiple values for parameter: %s", parameterName));
        }
    }
}

