/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.modules.oauth2.provider.internal.client;

import com.mulesoft.modules.oauth2.provider.api.Constants;
import com.mulesoft.modules.oauth2.provider.api.client.Client;
import com.mulesoft.modules.oauth2.provider.api.client.ClientAlreadyExistsException;
import com.mulesoft.modules.oauth2.provider.api.client.ClientStore;
import org.mule.runtime.api.util.Preconditions;

public class ClientManager {
    private ClientStore clientStore;

    public ClientManager(ClientStore clientStore) {
        this.clientStore = clientStore;
    }

    public void addClient(Client client, boolean failIfPresent) throws ClientAlreadyExistsException {
        this.checkClientConfiguration(client);
        this.clientStore.addClient(client, failIfPresent);
    }

    public void removeClient(String clientId) {
        this.clientStore.removeClient(clientId);
    }

    public Client getClientById(String id) {
        return this.clientStore.getClientById(id);
    }

    private void checkClientConfiguration(Client client) {
        Preconditions.checkArgument((!client.getAuthorizedGrantTypes().contains((Object)Constants.RequestGrantType.AUTHORIZATION_CODE) || !client.getRedirectUris().isEmpty() ? 1 : 0) != 0, (String)String.format("Client '%s' is authorized for %s grant type but does not have any redirect Uri", new Object[]{client.getClientName(), Constants.RequestGrantType.AUTHORIZATION_CODE}));
    }
}

