/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.modules.oauth2.provider.api.token;

import java.io.Serializable;
import java.time.Duration;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.core.api.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Token
implements Serializable {
    private static final long serialVersionUID = -2295676325723230622L;
    private final String type;
    private final String clientId;
    private final String accessToken;
    private final String refreshToken;
    private final Set<String> scopes;
    private final long expirationInterval;
    private final long timeOfCreation;
    private static final Logger logger = LoggerFactory.getLogger(Token.class);

    private Token(Builder builder) {
        Preconditions.checkArgument((builder != null ? 1 : 0) != 0, (String)"builder can't be null");
        Preconditions.checkArgument((!StringUtils.isEmpty((String)builder.type) ? 1 : 0) != 0, (String)"token type should be set in builder");
        Preconditions.checkArgument((!StringUtils.isEmpty((String)builder.clientId) ? 1 : 0) != 0, (String)"token's clientId should be set in builder");
        Preconditions.checkArgument((!StringUtils.isEmpty((String)builder.accessToken) ? 1 : 0) != 0, (String)"accessToken should be set in builder");
        Preconditions.checkArgument((builder.expirationInterval > 0L ? 1 : 0) != 0, (String)"token expiration interval should be bigger than 0");
        this.type = builder.type;
        this.clientId = builder.clientId;
        this.accessToken = builder.accessToken;
        this.refreshToken = builder.refreshToken;
        this.scopes = builder.scopes == null ? new HashSet() : builder.scopes;
        this.expirationInterval = builder.expirationInterval;
        this.timeOfCreation = TimeUnit.MILLISECONDS.toNanos(System.currentTimeMillis());
        if (logger.isDebugEnabled()) {
            logger.debug("Time of creation: {}, Expiration interval: {}", (Object)this.timeOfCreation, (Object)this.expirationInterval);
        }
    }

    public boolean hasRefreshToken() {
        return !StringUtils.isEmpty((String)this.refreshToken);
    }

    public String getClientId() {
        return this.clientId;
    }

    public String getAccessToken() {
        return this.accessToken;
    }

    public String getRefreshToken() {
        return this.refreshToken;
    }

    public Set<String> getScopes() {
        return this.scopes;
    }

    public String getType() {
        return this.type;
    }

    public Duration getExpiresIn() {
        long now = TimeUnit.MILLISECONDS.toNanos(System.currentTimeMillis());
        long elapsedTime = now - this.timeOfCreation;
        long expiresIn = this.expirationInterval - elapsedTime;
        if (logger.isDebugEnabled()) {
            logger.debug("Time of creation: {}, Now: {}, Elapsed time: {}, Expiration interval: {}, Expires in: {}", new Object[]{this.timeOfCreation, now, elapsedTime, this.expirationInterval, expiresIn});
        }
        return expiresIn <= 0L ? Duration.ZERO : Duration.ofNanos(expiresIn);
    }

    public static class Builder {
        private final String clientId;
        private final String accessToken;
        private String type;
        private String refreshToken;
        private Set<String> scopes;
        private long expirationInterval;

        public Builder(String accessToken, Token previousToken) {
            this.clientId = previousToken.getClientId();
            this.accessToken = accessToken;
            this.type = previousToken.getType();
            this.scopes = previousToken.getScopes();
            this.expirationInterval = previousToken.expirationInterval;
        }

        public Builder(String clientId, String accessToken) {
            this.clientId = clientId;
            this.accessToken = accessToken;
        }

        public Builder withRefreshToken(String refreshToken) {
            this.refreshToken = refreshToken;
            return this;
        }

        public Builder withScopes(Set<String> scopes) {
            this.scopes = scopes == null ? new HashSet() : scopes;
            return this;
        }

        public Builder withExpirationInterval(long intervalTime, TimeUnit intervalTimeUnit) {
            this.expirationInterval = intervalTimeUnit.toNanos(intervalTime);
            return this;
        }

        public Token build() {
            if (this.type == null) {
                this.type = "Bearer";
            }
            return new Token(this);
        }
    }
}

