/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.modules.oauth2.provider.api.token;

import com.mulesoft.modules.oauth2.provider.api.token.AccessTokenStoreHolder;
import com.mulesoft.modules.oauth2.provider.api.token.ObjectStoreAccessTokenStore;
import com.mulesoft.modules.oauth2.provider.api.token.TokenStore;
import org.apache.commons.lang3.StringUtils;
import org.mule.runtime.api.store.ObjectStore;

public class ObjectStoreAccessAndRefreshTokenStore
extends ObjectStoreAccessTokenStore
implements TokenStore {
    public static final String REFRESH_TOKENS_PARTITION = "RefreshTokens";
    private ObjectStore refreshTokenObjectStore;

    @Override
    public void store(AccessTokenStoreHolder accessTokenStoreHolder) {
        super.store(accessTokenStoreHolder);
        String refreshToken = accessTokenStoreHolder.getAccessToken().getRefreshToken();
        if (StringUtils.isNotBlank((CharSequence)refreshToken)) {
            this.putInObjectStore(refreshToken, accessTokenStoreHolder, this.refreshTokenObjectStore);
        }
    }

    @Override
    public AccessTokenStoreHolder retrieveByRefreshToken(String refreshToken) {
        return (AccessTokenStoreHolder)this.getFromObjectStore(refreshToken, this.refreshTokenObjectStore);
    }

    @Override
    public AccessTokenStoreHolder remove(String accessToken) {
        String refreshToken;
        AccessTokenStoreHolder accessTokenStoreHolder = super.remove(accessToken);
        if (accessTokenStoreHolder != null && StringUtils.isNotBlank((CharSequence)(refreshToken = accessTokenStoreHolder.getAccessToken().getRefreshToken()))) {
            return (AccessTokenStoreHolder)this.removeFromObjectStore(refreshToken, this.refreshTokenObjectStore);
        }
        return null;
    }

    @Override
    public void removeByRefreshToken(String refreshToken) {
        AccessTokenStoreHolder accessTokenStoreHolder = this.retrieveByRefreshToken(refreshToken);
        if (accessTokenStoreHolder != null) {
            this.removeFromObjectStore(refreshToken, this.refreshTokenObjectStore);
            String accessToken = accessTokenStoreHolder.getAccessToken().getAccessToken();
            if (StringUtils.isNotBlank((CharSequence)accessToken)) {
                this.removeFromObjectStore(accessToken, this.accessTokenObjectStore);
            }
        }
    }

    @Override
    public void setRefreshTokenObjectStore(ObjectStore refreshTokenObjectStore) {
        this.refreshTokenObjectStore = refreshTokenObjectStore;
    }
}

