/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.shaded.openpgp.operator.bc;

import java.io.OutputStream;
import java.security.SecureRandom;
import org.bouncycastle.shaded.bcpg.AEADUtils;
import org.bouncycastle.shaded.bcpg.SymmetricKeyUtils;
import org.bouncycastle.shaded.crypto.BlockCipher;
import org.bouncycastle.shaded.crypto.BufferedBlockCipher;
import org.bouncycastle.shaded.crypto.io.CipherOutputStream;
import org.bouncycastle.shaded.crypto.modes.AEADBlockCipher;
import org.bouncycastle.shaded.crypto.params.KeyParameter;
import org.bouncycastle.shaded.openpgp.PGPException;
import org.bouncycastle.shaded.openpgp.operator.PGPAEADDataEncryptor;
import org.bouncycastle.shaded.openpgp.operator.PGPDataEncryptor;
import org.bouncycastle.shaded.openpgp.operator.PGPDataEncryptorBuilder;
import org.bouncycastle.shaded.openpgp.operator.PGPDigestCalculator;
import org.bouncycastle.shaded.openpgp.operator.bc.BcAEADUtil;
import org.bouncycastle.shaded.openpgp.operator.bc.BcImplProvider;
import org.bouncycastle.shaded.openpgp.operator.bc.BcUtil;
import org.bouncycastle.shaded.openpgp.operator.bc.SHA1PGPDigestCalculator;
import org.bouncycastle.shaded.util.Arrays;

public class BcPGPDataEncryptorBuilder
implements PGPDataEncryptorBuilder {
    private SecureRandom random;
    private boolean withIntegrityPacket = true;
    private int encAlgorithm;
    private boolean isV5StyleAEAD = true;
    private int aeadAlgorithm = -1;
    private int chunkSize;

    public BcPGPDataEncryptorBuilder(int n) {
        this.encAlgorithm = n;
        if (n == 0) {
            throw new IllegalArgumentException("null cipher specified");
        }
    }

    @Override
    public BcPGPDataEncryptorBuilder setWithIntegrityPacket(boolean bl) {
        this.withIntegrityPacket = bl;
        return this;
    }

    @Override
    public BcPGPDataEncryptorBuilder setUseV5AEAD() {
        this.isV5StyleAEAD = true;
        return this;
    }

    @Override
    public BcPGPDataEncryptorBuilder setUseV6AEAD() {
        this.isV5StyleAEAD = false;
        return this;
    }

    @Override
    public BcPGPDataEncryptorBuilder setWithAEAD(int n, int n2) {
        if (this.encAlgorithm != 7 && this.encAlgorithm != 8 && this.encAlgorithm != 9) {
            throw new IllegalStateException("AEAD algorithms can only be used with AES");
        }
        if (n2 < 6) {
            throw new IllegalArgumentException("minimum chunkSize is 6");
        }
        this.aeadAlgorithm = n;
        this.chunkSize = n2 - 6;
        return this;
    }

    public BcPGPDataEncryptorBuilder setSecureRandom(SecureRandom secureRandom) {
        this.random = secureRandom;
        return this;
    }

    @Override
    public int getAlgorithm() {
        return this.encAlgorithm;
    }

    @Override
    public int getAeadAlgorithm() {
        return this.aeadAlgorithm;
    }

    @Override
    public int getChunkSize() {
        return this.chunkSize;
    }

    @Override
    public boolean isV5StyleAEAD() {
        return this.isV5StyleAEAD;
    }

    @Override
    public SecureRandom getSecureRandom() {
        if (this.random == null) {
            this.random = new SecureRandom();
        }
        return this.random;
    }

    @Override
    public PGPDataEncryptor build(byte[] byArray) throws PGPException {
        if (this.aeadAlgorithm > 0) {
            return new MyAeadDataEncryptor(byArray);
        }
        return new MyPGPDataEncryptor(byArray);
    }

    private class MyAeadDataEncryptor
    implements PGPAEADDataEncryptor {
        private final boolean isV5StyleAEAD;
        private final AEADBlockCipher c;
        private final byte[] keyBytes;
        private final byte[] iv;

        MyAeadDataEncryptor(byte[] byArray) throws PGPException {
            boolean bl = this.isV5StyleAEAD = byArray.length == SymmetricKeyUtils.getKeyLengthInOctets(BcPGPDataEncryptorBuilder.this.encAlgorithm);
            if (this.isV5StyleAEAD) {
                this.keyBytes = byArray;
                this.iv = new byte[AEADUtils.getIVLength((byte)BcPGPDataEncryptorBuilder.this.aeadAlgorithm)];
                BcPGPDataEncryptorBuilder.this.getSecureRandom().nextBytes(this.iv);
            } else {
                byte[][] byArray2 = AEADUtils.splitMessageKeyAndIv(byArray, BcPGPDataEncryptorBuilder.this.encAlgorithm, BcPGPDataEncryptorBuilder.this.aeadAlgorithm);
                this.keyBytes = byArray2[0];
                this.iv = byArray2[1];
            }
            this.c = BcAEADUtil.createAEADCipher(BcPGPDataEncryptorBuilder.this.encAlgorithm, BcPGPDataEncryptorBuilder.this.aeadAlgorithm);
        }

        @Override
        public OutputStream getOutputStream(OutputStream outputStream) {
            try {
                return new BcAEADUtil.PGPAeadOutputStream(this.isV5StyleAEAD, outputStream, this.c, new KeyParameter(this.keyBytes), this.iv, BcPGPDataEncryptorBuilder.this.encAlgorithm, BcPGPDataEncryptorBuilder.this.aeadAlgorithm, BcPGPDataEncryptorBuilder.this.chunkSize);
            }
            catch (Exception exception) {
                throw new IllegalStateException("unable to process stream: " + exception.getMessage());
            }
        }

        @Override
        public PGPDigestCalculator getIntegrityCalculator() {
            return null;
        }

        @Override
        public int getBlockSize() {
            return this.c.getUnderlyingCipher().getBlockSize();
        }

        @Override
        public int getAEADAlgorithm() {
            return BcPGPDataEncryptorBuilder.this.aeadAlgorithm;
        }

        @Override
        public int getChunkSize() {
            return BcPGPDataEncryptorBuilder.this.chunkSize;
        }

        @Override
        public byte[] getIV() {
            return Arrays.clone(this.iv);
        }
    }

    private class MyPGPDataEncryptor
    implements PGPDataEncryptor {
        private final BufferedBlockCipher c;

        MyPGPDataEncryptor(byte[] byArray) throws PGPException {
            BlockCipher blockCipher = BcImplProvider.createBlockCipher(BcPGPDataEncryptorBuilder.this.encAlgorithm);
            try {
                this.c = BcUtil.createStreamCipher(true, blockCipher, BcPGPDataEncryptorBuilder.this.withIntegrityPacket, byArray);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new PGPException("invalid parameters: " + illegalArgumentException.getMessage(), illegalArgumentException);
            }
        }

        @Override
        public OutputStream getOutputStream(OutputStream outputStream) {
            return new CipherOutputStream(outputStream, this.c);
        }

        @Override
        public PGPDigestCalculator getIntegrityCalculator() {
            if (BcPGPDataEncryptorBuilder.this.withIntegrityPacket) {
                return new SHA1PGPDigestCalculator();
            }
            return null;
        }

        @Override
        public int getBlockSize() {
            return this.c.getBlockSize();
        }
    }
}

