/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.shaded.openpgp.operator.bc;

import org.bouncycastle.shaded.bcpg.AEADEncDataPacket;
import org.bouncycastle.shaded.bcpg.SymmetricEncIntegrityPacket;
import org.bouncycastle.shaded.bcpg.SymmetricKeyEncSessionPacket;
import org.bouncycastle.shaded.bcpg.SymmetricKeyUtils;
import org.bouncycastle.shaded.crypto.BlockCipher;
import org.bouncycastle.shaded.crypto.BufferedBlockCipher;
import org.bouncycastle.shaded.crypto.InvalidCipherTextException;
import org.bouncycastle.shaded.crypto.digests.SHA256Digest;
import org.bouncycastle.shaded.crypto.generators.HKDFBytesGenerator;
import org.bouncycastle.shaded.crypto.modes.AEADBlockCipher;
import org.bouncycastle.shaded.crypto.params.AEADParameters;
import org.bouncycastle.shaded.crypto.params.HKDFParameters;
import org.bouncycastle.shaded.crypto.params.KeyParameter;
import org.bouncycastle.shaded.openpgp.PGPException;
import org.bouncycastle.shaded.openpgp.PGPSessionKey;
import org.bouncycastle.shaded.openpgp.operator.PBEDataDecryptorFactory;
import org.bouncycastle.shaded.openpgp.operator.PGPDataDecryptor;
import org.bouncycastle.shaded.openpgp.operator.bc.BcAEADUtil;
import org.bouncycastle.shaded.openpgp.operator.bc.BcImplProvider;
import org.bouncycastle.shaded.openpgp.operator.bc.BcPGPDigestCalculatorProvider;
import org.bouncycastle.shaded.openpgp.operator.bc.BcUtil;

public class BcPBEDataDecryptorFactory
extends PBEDataDecryptorFactory {
    public BcPBEDataDecryptorFactory(char[] cArray, BcPGPDigestCalculatorProvider bcPGPDigestCalculatorProvider) {
        super(cArray, bcPGPDigestCalculatorProvider);
    }

    @Override
    public byte[] recoverSessionData(int n, byte[] byArray, byte[] byArray2) throws PGPException {
        try {
            if (byArray2 != null && byArray2.length > 0) {
                BlockCipher blockCipher = BcImplProvider.createBlockCipher(n);
                BufferedBlockCipher bufferedBlockCipher = BcUtil.createSymmetricKeyWrapper(false, blockCipher, byArray, new byte[blockCipher.getBlockSize()]);
                byte[] byArray3 = new byte[byArray2.length];
                int n2 = bufferedBlockCipher.processBytes(byArray2, 0, byArray2.length, byArray3, 0);
                n2 += bufferedBlockCipher.doFinal(byArray3, n2);
                return byArray3;
            }
            byte[] byArray4 = new byte[byArray.length + 1];
            byArray4[0] = (byte)n;
            System.arraycopy(byArray, 0, byArray4, 1, byArray.length);
            return byArray4;
        }
        catch (Exception exception) {
            throw new PGPException("Exception recovering session info", exception);
        }
    }

    @Override
    public byte[] recoverAEADEncryptedSessionData(SymmetricKeyEncSessionPacket symmetricKeyEncSessionPacket, byte[] byArray) throws PGPException {
        if (symmetricKeyEncSessionPacket.getVersion() < 5) {
            throw new PGPException("SKESK packet MUST be version 5 or later.");
        }
        byte[] byArray2 = symmetricKeyEncSessionPacket.getAAData();
        int n = SymmetricKeyUtils.getKeyLengthInOctets(symmetricKeyEncSessionPacket.getEncAlgorithm());
        byte[] byArray3 = new byte[n];
        HKDFBytesGenerator hKDFBytesGenerator = new HKDFBytesGenerator(new SHA256Digest());
        hKDFBytesGenerator.init(new HKDFParameters(byArray, null, byArray2));
        hKDFBytesGenerator.generateBytes(byArray3, 0, byArray3.length);
        KeyParameter keyParameter = new KeyParameter(byArray3);
        AEADBlockCipher aEADBlockCipher = BcAEADUtil.createAEADCipher(symmetricKeyEncSessionPacket.getEncAlgorithm(), symmetricKeyEncSessionPacket.getAeadAlgorithm());
        int n2 = 128;
        byte[] byArray4 = symmetricKeyEncSessionPacket.getAuthTag();
        byte[] byArray5 = symmetricKeyEncSessionPacket.getIv();
        byte[] byArray6 = symmetricKeyEncSessionPacket.getSecKeyData();
        AEADParameters aEADParameters = new AEADParameters(keyParameter, n2, byArray5, symmetricKeyEncSessionPacket.getAAData());
        aEADBlockCipher.init(false, aEADParameters);
        int n3 = aEADBlockCipher.getOutputSize(byArray6.length + byArray4.length);
        byte[] byArray7 = new byte[n3];
        int n4 = aEADBlockCipher.processBytes(byArray6, 0, byArray6.length, byArray7, 0);
        n4 += aEADBlockCipher.processBytes(byArray4, 0, byArray4.length, byArray7, n4);
        try {
            aEADBlockCipher.doFinal(byArray7, n4);
        }
        catch (InvalidCipherTextException invalidCipherTextException) {
            throw new PGPException("Exception recovering session info", invalidCipherTextException);
        }
        return byArray7;
    }

    @Override
    public PGPDataDecryptor createDataDecryptor(boolean bl, int n, byte[] byArray) throws PGPException {
        BlockCipher blockCipher = BcImplProvider.createBlockCipher(n);
        return BcUtil.createDataDecryptor(bl, blockCipher, byArray);
    }

    @Override
    public PGPDataDecryptor createDataDecryptor(AEADEncDataPacket aEADEncDataPacket, PGPSessionKey pGPSessionKey) throws PGPException {
        return BcAEADUtil.createOpenPgpV5DataDecryptor(aEADEncDataPacket, pGPSessionKey);
    }

    @Override
    public PGPDataDecryptor createDataDecryptor(SymmetricEncIntegrityPacket symmetricEncIntegrityPacket, PGPSessionKey pGPSessionKey) throws PGPException {
        return BcAEADUtil.createOpenPgpV6DataDecryptor(symmetricEncIntegrityPacket, pGPSessionKey);
    }
}

