/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.shaded.openpgp;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigInteger;
import java.util.Date;
import org.bouncycastle.shaded.bcpg.MPInteger;
import org.bouncycastle.shaded.bcpg.OnePassSignaturePacket;
import org.bouncycastle.shaded.bcpg.SignaturePacket;
import org.bouncycastle.shaded.openpgp.PGPException;
import org.bouncycastle.shaded.openpgp.PGPOnePassSignature;
import org.bouncycastle.shaded.openpgp.PGPPrivateKey;
import org.bouncycastle.shaded.openpgp.PGPRuntimeOperationException;
import org.bouncycastle.shaded.openpgp.PGPSignature;
import org.bouncycastle.shaded.openpgp.PGPUtil;
import org.bouncycastle.shaded.openpgp.operator.PGPContentSigner;
import org.bouncycastle.shaded.openpgp.operator.PGPContentSignerBuilder;

public class PGPV3SignatureGenerator {
    private byte lastb;
    private OutputStream sigOut;
    private PGPContentSignerBuilder contentSignerBuilder;
    private PGPContentSigner contentSigner;
    private int sigType;
    private int providedKeyAlgorithm = -1;

    public PGPV3SignatureGenerator(PGPContentSignerBuilder pGPContentSignerBuilder) {
        this.contentSignerBuilder = pGPContentSignerBuilder;
    }

    public void init(int n, PGPPrivateKey pGPPrivateKey) throws PGPException {
        this.contentSigner = this.contentSignerBuilder.build(n, pGPPrivateKey);
        this.sigOut = this.contentSigner.getOutputStream();
        this.sigType = this.contentSigner.getType();
        this.lastb = 0;
        if (this.providedKeyAlgorithm >= 0 && this.providedKeyAlgorithm != this.contentSigner.getKeyAlgorithm()) {
            throw new PGPException("key algorithm mismatch");
        }
    }

    public void update(byte by) {
        if (this.sigType == 1) {
            if (by == 13) {
                this.byteUpdate((byte)13);
                this.byteUpdate((byte)10);
            } else if (by == 10) {
                if (this.lastb != 13) {
                    this.byteUpdate((byte)13);
                    this.byteUpdate((byte)10);
                }
            } else {
                this.byteUpdate(by);
            }
            this.lastb = by;
        } else {
            this.byteUpdate(by);
        }
    }

    public void update(byte[] byArray) {
        this.update(byArray, 0, byArray.length);
    }

    public void update(byte[] byArray, int n, int n2) {
        if (this.sigType == 1) {
            int n3 = n + n2;
            for (int i = n; i != n3; ++i) {
                this.update(byArray[i]);
            }
        } else {
            this.blockUpdate(byArray, n, n2);
        }
    }

    private void byteUpdate(byte by) {
        try {
            this.sigOut.write(by);
        }
        catch (IOException iOException) {
            throw new PGPRuntimeOperationException("unable to update signature: " + iOException.getMessage(), iOException);
        }
    }

    private void blockUpdate(byte[] byArray, int n, int n2) {
        try {
            this.sigOut.write(byArray, n, n2);
        }
        catch (IOException iOException) {
            throw new PGPRuntimeOperationException("unable to update signature: " + iOException.getMessage(), iOException);
        }
    }

    public PGPOnePassSignature generateOnePassVersion(boolean bl) throws PGPException {
        return new PGPOnePassSignature(new OnePassSignaturePacket(this.sigType, this.contentSigner.getHashAlgorithm(), this.contentSigner.getKeyAlgorithm(), this.contentSigner.getKeyID(), bl));
    }

    public PGPSignature generate() throws PGPException {
        long l = new Date().getTime() / 1000L;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byteArrayOutputStream.write(this.sigType);
        byteArrayOutputStream.write((byte)(l >> 24));
        byteArrayOutputStream.write((byte)(l >> 16));
        byteArrayOutputStream.write((byte)(l >> 8));
        byteArrayOutputStream.write((byte)l);
        byte[] byArray = byteArrayOutputStream.toByteArray();
        this.blockUpdate(byArray, 0, byArray.length);
        MPInteger[] mPIntegerArray = this.contentSigner.getKeyAlgorithm() == 3 || this.contentSigner.getKeyAlgorithm() == 1 ? new MPInteger[]{new MPInteger(new BigInteger(1, this.contentSigner.getSignature()))} : PGPUtil.dsaSigToMpi(this.contentSigner.getSignature());
        byte[] byArray2 = this.contentSigner.getDigest();
        byte[] byArray3 = new byte[]{byArray2[0], byArray2[1]};
        return new PGPSignature(new SignaturePacket(3, this.contentSigner.getType(), this.contentSigner.getKeyID(), this.contentSigner.getKeyAlgorithm(), this.contentSigner.getHashAlgorithm(), l * 1000L, byArray3, mPIntegerArray));
    }
}

