/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.shaded.gpg.keybox.jcajce;

import java.io.IOException;
import java.io.InputStream;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import org.bouncycastle.shaded.gpg.keybox.BlobVerifier;
import org.bouncycastle.shaded.gpg.keybox.jcajce.JcaBlobVerifier;
import org.bouncycastle.shaded.gpg.keybox.jcajce.JcaKeyBox;
import org.bouncycastle.shaded.jcajce.util.DefaultJcaJceHelper;
import org.bouncycastle.shaded.jcajce.util.JcaJceHelper;
import org.bouncycastle.shaded.jcajce.util.NamedJcaJceHelper;
import org.bouncycastle.shaded.jcajce.util.ProviderJcaJceHelper;
import org.bouncycastle.shaded.openpgp.operator.KeyFingerPrintCalculator;
import org.bouncycastle.shaded.openpgp.operator.jcajce.JcaKeyFingerprintCalculator;

public class JcaKeyBoxBuilder {
    private JcaJceHelper helper = new DefaultJcaJceHelper();

    public JcaKeyBoxBuilder setProvider(Provider provider) {
        this.helper = new ProviderJcaJceHelper(provider);
        return this;
    }

    public JcaKeyBoxBuilder setProvider(String string) {
        this.helper = new NamedJcaJceHelper(string);
        return this;
    }

    public JcaKeyBox build(InputStream inputStream) throws NoSuchProviderException, NoSuchAlgorithmException, IOException {
        return new JcaKeyBox(inputStream, (KeyFingerPrintCalculator)new JcaKeyFingerprintCalculator(), (BlobVerifier)new JcaBlobVerifier(this.helper));
    }

    public JcaKeyBox build(byte[] byArray) throws NoSuchProviderException, NoSuchAlgorithmException, IOException {
        return new JcaKeyBox(byArray, (KeyFingerPrintCalculator)new JcaKeyFingerprintCalculator(), (BlobVerifier)new JcaBlobVerifier(this.helper));
    }
}

