/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.modules.cryptography.internal.xml.impl;

import com.mulesoft.modules.cryptography.api.jce.config.JceSymmetricKeyInfo;
import com.mulesoft.modules.cryptography.api.xml.config.XmlCanonicalizationAlgorithm;
import com.mulesoft.modules.cryptography.api.xml.config.XmlEncryptionAlgorithm;
import com.mulesoft.modules.cryptography.api.xml.config.XmlSignDigestAlgorithm;
import com.mulesoft.modules.cryptography.api.xml.config.XmlSignatureType;
import com.mulesoft.modules.cryptography.internal.errors.CryptoErrors;
import com.mulesoft.modules.cryptography.internal.jce.config.JceConfiguration;
import com.mulesoft.modules.cryptography.internal.xml.XMLUtils;
import com.mulesoft.modules.cryptography.internal.xml.impl.XmlKeyImpl;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.security.Key;
import org.apache.xml.security.encryption.EncryptedData;
import org.apache.xml.security.encryption.XMLCipher;
import org.apache.xml.security.keys.KeyInfo;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.core.api.util.IOUtils;
import org.mule.runtime.core.api.util.StringUtils;
import org.mule.runtime.extension.api.error.ErrorTypeDefinition;
import org.mule.runtime.extension.api.exception.ModuleException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class XmlSymmetricKeyImpl
extends XmlKeyImpl {
    private final JceConfiguration config;
    private final JceSymmetricKeyInfo keyInfo;

    public XmlSymmetricKeyImpl(JceConfiguration config, JceSymmetricKeyInfo keyInfo) {
        this.config = config;
        this.keyInfo = keyInfo;
    }

    @Override
    public InputStream encrypt(InputStream content, XmlEncryptionAlgorithm algorithm, String elementPath, boolean encryptContent) {
        try {
            byte[] xmlBytes = IOUtils.toByteArray((InputStream)content);
            Document document = XMLUtils.documentBasedOnThe(xmlBytes);
            Key symmetricKey = this.keyInfo.getSymmetricKey(this.config.getKeystore());
            XMLCipher xmlCipher = XMLCipher.getInstance((String)algorithm.getInfo().getAlgorithm(symmetricKey.getEncoded().length));
            xmlCipher.init(1, symmetricKey);
            EncryptedData encryptedDataElement = xmlCipher.getEncryptedData();
            KeyInfo xmlKeyInfo = new KeyInfo(document);
            xmlKeyInfo.addKeyName(this.keyInfo.getKeyId());
            encryptedDataElement.setKeyInfo(xmlKeyInfo);
            NodeList elementsToEncrypt = XMLUtils.getElements(elementPath, document);
            for (int i = 0; i < elementsToEncrypt.getLength(); ++i) {
                Element item = (Element)elementsToEncrypt.item(i);
                xmlCipher.doFinal(document, item, encryptContent);
            }
            return new ByteArrayInputStream(XMLUtils.createXmlUsing(document));
        }
        catch (ModuleException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ModuleException(I18nMessageFactory.createStaticMessage((String)"Could not encrypt data"), (ErrorTypeDefinition)CryptoErrors.ENCRYPTION, (Throwable)e);
        }
    }

    @Override
    public InputStream decrypt(InputStream content, String elementPath) {
        try {
            byte[] xmlBytes = IOUtils.toByteArray((InputStream)content);
            Document document = XMLUtils.documentBasedOnThe(xmlBytes);
            Key symmetricKey = this.keyInfo.getSymmetricKey(this.config.getKeystore());
            XMLCipher xmlCipher = XMLCipher.getInstance();
            xmlCipher.init(2, symmetricKey);
            NodeList elementsToDecrypt = StringUtils.isBlank((String)elementPath) ? document.getElementsByTagNameNS("http://www.w3.org/2001/04/xmlenc#", "EncryptedData") : XMLUtils.getElements(elementPath, document);
            int numberOfElements = elementsToDecrypt.getLength();
            for (int i = 0; i < numberOfElements; ++i) {
                Element item = (Element)elementsToDecrypt.item(0);
                if (!item.getLocalName().equals("EncryptedData") || !item.getNamespaceURI().equals("http://www.w3.org/2001/04/xmlenc#")) {
                    throw new RuntimeException("Trying to decrypt a non encrypted element. Invalid elementPath");
                }
                xmlCipher.doFinal(document, item);
            }
            return new ByteArrayInputStream(XMLUtils.createXmlUsing(document));
        }
        catch (ModuleException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ModuleException(I18nMessageFactory.createStaticMessage((String)"Could not decrypt data"), (ErrorTypeDefinition)CryptoErrors.DECRYPTION, (Throwable)e);
        }
    }

    @Override
    public InputStream sign(InputStream content, XmlSignDigestAlgorithm digestAlgorithm, XmlCanonicalizationAlgorithm canonicalizationAlgorithm, XmlSignatureType type, String elementPath) {
        throw new ModuleException(I18nMessageFactory.createStaticMessage((String)"XML signature is not available for symmetric keys, use an asymmetric one instead."), (ErrorTypeDefinition)CryptoErrors.PARAMETERS);
    }

    @Override
    public boolean validate(InputStream content, String elementPath) {
        throw new ModuleException(I18nMessageFactory.createStaticMessage((String)"XML signature validation is not available for symmetric keys, use an asymmetric one instead."), (ErrorTypeDefinition)CryptoErrors.PARAMETERS);
    }
}

