/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.modules.cryptography.internal;

import java.security.Provider;
import java.security.Security;
import java.util.Arrays;
import java.util.Optional;
import org.bouncycastle.shaded.jce.provider.BouncyCastleProvider;

public class FipsUtils {
    private static final String BOUNCY_CASTLE_SECURITY_PROVIDER_NAME = BouncyCastleProviderInstanceHolder.access$000().getName();

    private FipsUtils() {
    }

    public static boolean isFipsEnabled() {
        return "fips140-2".equals(System.getProperty("mule.security.model"));
    }

    public static Optional<Provider> getBcSecurityProviderIfApplicable() {
        return !FipsUtils.isFipsEnabled() && !FipsUtils.isBouncyCastleProviderPresent() ? Optional.of(BouncyCastleProviderInstanceHolder.INSTANCE) : Optional.empty();
    }

    private static boolean isBouncyCastleProviderPresent() {
        return Arrays.stream(Security.getProviders()).anyMatch(provider -> provider.getName().equals(BOUNCY_CASTLE_SECURITY_PROVIDER_NAME));
    }

    private static class BouncyCastleProviderInstanceHolder {
        private static final Provider INSTANCE = new BouncyCastleProvider();

        private BouncyCastleProviderInstanceHolder() {
        }
    }
}

