/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.shaded.bcpg;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import org.bouncycastle.shaded.bcpg.BCPGInputStream;
import org.bouncycastle.shaded.bcpg.BCPGOutputStream;
import org.bouncycastle.shaded.bcpg.ContainedPacket;

public class TrustPacket
extends ContainedPacket {
    byte[] levelAndTrustAmount;

    public TrustPacket(BCPGInputStream bCPGInputStream) throws IOException {
        int n;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        while ((n = bCPGInputStream.read()) >= 0) {
            byteArrayOutputStream.write(n);
        }
        this.levelAndTrustAmount = byteArrayOutputStream.toByteArray();
    }

    public TrustPacket(int n) {
        this.levelAndTrustAmount = new byte[1];
        this.levelAndTrustAmount[0] = (byte)n;
    }

    public byte[] getLevelAndTrustAmount() {
        return this.levelAndTrustAmount;
    }

    @Override
    public void encode(BCPGOutputStream bCPGOutputStream) throws IOException {
        bCPGOutputStream.writePacket(12, this.levelAndTrustAmount);
    }
}

