/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.modules.cryptography.internal.xml.impl;

import com.mulesoft.modules.cryptography.api.jce.config.JceAsymmetricKeyInfo;
import com.mulesoft.modules.cryptography.api.xml.config.EphemeralKeyInfo;
import com.mulesoft.modules.cryptography.api.xml.config.XmlCanonicalizationAlgorithm;
import com.mulesoft.modules.cryptography.api.xml.config.XmlEncryptionAlgorithm;
import com.mulesoft.modules.cryptography.api.xml.config.XmlSignDigestAlgorithm;
import com.mulesoft.modules.cryptography.api.xml.config.XmlSignatureType;
import com.mulesoft.modules.cryptography.internal.errors.CryptoErrors;
import com.mulesoft.modules.cryptography.internal.jce.config.JceConfiguration;
import com.mulesoft.modules.cryptography.internal.xml.NodeListUtils;
import com.mulesoft.modules.cryptography.internal.xml.XMLUtils;
import com.mulesoft.modules.cryptography.internal.xml.config.XmlSignEncryptionAlgorithm;
import com.mulesoft.modules.cryptography.internal.xml.impl.SignatureFilterSelector;
import com.mulesoft.modules.cryptography.internal.xml.impl.X509KeySelector;
import com.mulesoft.modules.cryptography.internal.xml.impl.XmlKeyImpl;
import com.mulesoft.modules.cryptography.internal.xml.reference.SignatureContextProvider;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.security.Key;
import java.security.KeyStore;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import javax.xml.crypto.KeySelector;
import javax.xml.crypto.MarshalException;
import javax.xml.crypto.dsig.CanonicalizationMethod;
import javax.xml.crypto.dsig.Reference;
import javax.xml.crypto.dsig.SignatureMethod;
import javax.xml.crypto.dsig.SignedInfo;
import javax.xml.crypto.dsig.XMLSignature;
import javax.xml.crypto.dsig.XMLSignatureException;
import javax.xml.crypto.dsig.XMLValidateContext;
import javax.xml.crypto.dsig.dom.DOMSignContext;
import javax.xml.crypto.dsig.dom.DOMValidateContext;
import javax.xml.crypto.dsig.keyinfo.KeyInfoFactory;
import javax.xml.crypto.dsig.keyinfo.X509Data;
import javax.xml.crypto.dsig.spec.C14NMethodParameterSpec;
import org.apache.commons.lang3.StringUtils;
import org.apache.xml.security.encryption.EncryptedData;
import org.apache.xml.security.encryption.EncryptedKey;
import org.apache.xml.security.encryption.XMLCipher;
import org.apache.xml.security.keys.KeyInfo;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.util.Pair;
import org.mule.runtime.core.api.util.IOUtils;
import org.mule.runtime.extension.api.error.ErrorTypeDefinition;
import org.mule.runtime.extension.api.exception.ModuleException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XmlAsymmetricKeyImpl
extends XmlKeyImpl {
    public static final String DSIG_PREFIX = "dsig";
    private final JceConfiguration config;
    private final JceAsymmetricKeyInfo keyInfo;
    private final EphemeralKeyInfo ephemeralKeyInfo;
    private final boolean useInternalCertificate;

    public XmlAsymmetricKeyImpl(JceConfiguration config, JceAsymmetricKeyInfo keyInfo, EphemeralKeyInfo ephemeralKeyInfo) {
        this(config, keyInfo, ephemeralKeyInfo, false);
    }

    public XmlAsymmetricKeyImpl(JceConfiguration config, JceAsymmetricKeyInfo keyInfo, boolean useInternalCertificate) {
        this(config, keyInfo, null, useInternalCertificate);
    }

    public XmlAsymmetricKeyImpl(JceConfiguration config, JceAsymmetricKeyInfo keyInfo, EphemeralKeyInfo ephemeralKeyInfo, boolean useInternalCertificate) {
        this.config = config;
        this.keyInfo = keyInfo;
        this.ephemeralKeyInfo = ephemeralKeyInfo;
        this.useInternalCertificate = useInternalCertificate;
    }

    @Override
    public InputStream encrypt(InputStream content, XmlEncryptionAlgorithm algorithm, String elementPath, boolean encryptContent) {
        Document document = XMLUtils.documentBasedOnThe(IOUtils.toByteArray((InputStream)content));
        try {
            if (StringUtils.isNotBlank((CharSequence)elementPath)) {
                NodeList elementsToEncrypt = XMLUtils.getElements(elementPath, document);
                int numberOfElements = elementsToEncrypt.getLength();
                for (int i = 0; i < numberOfElements; ++i) {
                    this.encryptElement(algorithm, document, (Element)elementsToEncrypt.item(i), encryptContent);
                }
            } else {
                this.encryptElement(algorithm, document, document.getDocumentElement(), encryptContent);
            }
            return new ByteArrayInputStream(XMLUtils.createXmlUsing(document));
        }
        catch (ModuleException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ModuleException(I18nMessageFactory.createStaticMessage((String)"Could not encrypt document"), (ErrorTypeDefinition)CryptoErrors.ENCRYPTION, (Throwable)e);
        }
    }

    @Override
    public InputStream decrypt(InputStream content, String elementPath) {
        Document document = XMLUtils.documentBasedOnThe(IOUtils.toByteArray((InputStream)content));
        Key privateKey = this.keyInfo.getPrivateKey(this.config.getKeystore());
        try {
            NodeList elementsToDecrypt = org.mule.runtime.core.api.util.StringUtils.isBlank((String)elementPath) ? document.getElementsByTagNameNS("http://www.w3.org/2001/04/xmlenc#", "EncryptedData") : XMLUtils.getElements(elementPath, document);
            int numberOfElements = elementsToDecrypt.getLength();
            XMLCipher xmlCipher = XMLCipher.getInstance();
            xmlCipher.setKEK(privateKey);
            for (int i = 0; i < numberOfElements; ++i) {
                Element item = (Element)elementsToDecrypt.item(0);
                if (!item.getLocalName().equals("EncryptedData") || !item.getNamespaceURI().equals("http://www.w3.org/2001/04/xmlenc#")) {
                    throw new RuntimeException("Trying to decrypt a non encrypted element. Invalid elementPath");
                }
                xmlCipher.init(2, null);
                xmlCipher.doFinal(document, item);
            }
            return new ByteArrayInputStream(XMLUtils.createXmlUsing(document));
        }
        catch (ModuleException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ModuleException(I18nMessageFactory.createStaticMessage((String)"Could not decrypt document"), (ErrorTypeDefinition)CryptoErrors.DECRYPTION, (Throwable)e);
        }
    }

    @Override
    public InputStream sign(InputStream content, XmlSignDigestAlgorithm digestAlgorithm, XmlCanonicalizationAlgorithm canonicalizationAlgorithm, XmlSignatureType type, String elementPath) {
        Document document = XMLUtils.documentBasedOnThe(IOUtils.toByteArray((InputStream)content));
        SignatureContextProvider contextProvider = SignatureContextProvider.createContextFor(type, digestAlgorithm, document, elementPath);
        try {
            document = contextProvider.preProcess(document);
            Reference reference = contextProvider.getReference();
            Key key = this.keyInfo.getPrivateKey(this.config.getKeystore());
            KeyStore.Entry keyEntry = this.keyInfo.getEntry(this.config.getKeystore());
            XMLSignature signature = fac.newXMLSignature(this.getSignedInfo(reference, canonicalizationAlgorithm, key), this.getKeyInfo((KeyStore.PrivateKeyEntry)keyEntry), contextProvider.getReferencedObjects(), null, null);
            DOMSignContext signContext = new DOMSignContext(key, contextProvider.getSignatureParentNode());
            signContext.setDefaultNamespacePrefix(DSIG_PREFIX);
            signature.sign(signContext);
            document = contextProvider.postProcess(document);
            return new ByteArrayInputStream(XMLUtils.createXmlUsing(document));
        }
        catch (ModuleException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ModuleException(I18nMessageFactory.createStaticMessage((String)"Could not sign document"), (ErrorTypeDefinition)CryptoErrors.SIGNATURE, (Throwable)e);
        }
    }

    @Override
    public boolean validate(InputStream content, String elementPath) {
        try {
            byte[] xmlBytes = IOUtils.toByteArray((InputStream)content);
            Document document = XMLUtils.documentBasedOnThe(xmlBytes);
            NodeList nl = document.getElementsByTagNameNS("http://www.w3.org/2000/09/xmldsig#", "Signature");
            if (nl.getLength() == 0) {
                throw new IllegalStateException("Could not find Signature element");
            }
            if (nl.getLength() > 1 && elementPath == null) {
                throw new IllegalStateException("More than one signature was found in the xml source. Try to target the desired one with the elementPath attribute.");
            }
            List<Node> signatures = NodeListUtils.toList(nl);
            Optional<Pair<DOMValidateContext, XMLSignature>> targetedSignaturePair = signatures.stream().map(this::nodeToValidationContextAndSignature).filter(SignatureFilterSelector.forDocumentAndElementPath(document, elementPath)).findFirst();
            if (!targetedSignaturePair.isPresent()) {
                throw new ModuleException(I18nMessageFactory.createStaticMessage((String)"Could not find the targeted signature"), (ErrorTypeDefinition)CryptoErrors.VALIDATION);
            }
            return this.validateSignaturePair(targetedSignaturePair.get());
        }
        catch (ModuleException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ModuleException(I18nMessageFactory.createStaticMessage((String)"Could not validate signature"), (ErrorTypeDefinition)CryptoErrors.VALIDATION, (Throwable)e);
        }
    }

    protected boolean validateSignaturePair(Pair<DOMValidateContext, XMLSignature> contextAndSignature) throws XMLSignatureException {
        return ((XMLSignature)contextAndSignature.getSecond()).validate((XMLValidateContext)contextAndSignature.getFirst());
    }

    protected Pair<DOMValidateContext, XMLSignature> nodeToValidationContextAndSignature(Node node) {
        DOMValidateContext context = new DOMValidateContext(this.getKeySelector(), node);
        try {
            return new Pair((Object)context, (Object)fac.unmarshalXMLSignature(context));
        }
        catch (MarshalException e) {
            throw new ModuleException(e.getMessage(), (ErrorTypeDefinition)CryptoErrors.VALIDATION);
        }
    }

    private KeySelector getKeySelector() {
        if (this.useInternalCertificate) {
            return new X509KeySelector(this.config.getKeystore().getUnderlyingKeyStore(), true);
        }
        return KeySelector.singletonKeySelector(this.keyInfo.getPublicKey(this.config.getKeystore()));
    }

    private SignedInfo getSignedInfo(Reference ref, XmlCanonicalizationAlgorithm canonicalizationAlgorithm, Key key) throws Exception {
        String algorithm;
        if (key.getAlgorithm().equalsIgnoreCase("RSA")) {
            algorithm = this.isCurrentJavaVersionAtLeast17() ? XmlSignEncryptionAlgorithm.RSA_SHA256.getAlgorithm() : XmlSignEncryptionAlgorithm.RSA_SHA1.getAlgorithm();
        } else if (key.getAlgorithm().equalsIgnoreCase("DSA")) {
            algorithm = XmlSignEncryptionAlgorithm.DSA_SHA1.getAlgorithm();
        } else if (key.getAlgorithm().equalsIgnoreCase("EC")) {
            algorithm = XmlSignEncryptionAlgorithm.ECDSA_SHA256.getAlgorithm();
        } else {
            throw new ModuleException(I18nMessageFactory.createStaticMessage((String)("Supported keys are RSA and DSA, but found " + key.getAlgorithm())), (ErrorTypeDefinition)CryptoErrors.PARAMETERS);
        }
        CanonicalizationMethod canonicalizationMethod = fac.newCanonicalizationMethod(canonicalizationAlgorithm.getAlgorithm(), (C14NMethodParameterSpec)null);
        SignatureMethod signatureMethod = fac.newSignatureMethod(algorithm, null);
        return fac.newSignedInfo(canonicalizationMethod, signatureMethod, Collections.singletonList(ref));
    }

    private void encryptElement(XmlEncryptionAlgorithm algorithm, Document document, Element element, boolean encryptContent) throws Exception {
        Key publicKey = this.keyInfo.getPublicKey(this.config.getKeystore());
        Key symmetricKey = this.ephemeralKeyInfo.createSymmetricKey(algorithm);
        XMLCipher keyCipher = XMLCipher.getInstance((String)this.ephemeralKeyInfo.getEncryptionAlgorithm().getAlgorithm(), (String)this.ephemeralKeyInfo.getC14nAlgorithm().getAlgorithm(), (String)this.ephemeralKeyInfo.getDigestAlgorithm().getAlgorithm());
        keyCipher.init(3, publicKey);
        EncryptedKey encryptedKey = keyCipher.encryptKey(document, symmetricKey);
        KeyInfo symKeyInfo = new KeyInfo(document);
        symKeyInfo.addKeyName(this.keyInfo.getKeyId());
        encryptedKey.setRecipient(this.keyInfo.getKeyId());
        encryptedKey.setKeyInfo(symKeyInfo);
        XMLCipher xmlCipher = XMLCipher.getInstance((String)algorithm.getInfo().getAlgorithm(symmetricKey.getEncoded().length));
        xmlCipher.init(1, symmetricKey);
        EncryptedData encryptedData = xmlCipher.getEncryptedData();
        KeyInfo keyInfo = new KeyInfo(document);
        keyInfo.add(encryptedKey);
        encryptedData.setKeyInfo(keyInfo);
        xmlCipher.doFinal(document, element, encryptContent);
    }

    public javax.xml.crypto.dsig.keyinfo.KeyInfo getKeyInfo(KeyStore.PrivateKeyEntry keyEntry) {
        X509Certificate cert = (X509Certificate)keyEntry.getCertificate();
        KeyInfoFactory kif = fac.getKeyInfoFactory();
        ArrayList<Object> x509Content = new ArrayList<Object>();
        x509Content.add(cert.getSubjectX500Principal().getName());
        x509Content.add(cert);
        X509Data xd = kif.newX509Data(x509Content);
        return kif.newKeyInfo(Collections.singletonList(xd));
    }

    private boolean isCurrentJavaVersionAtLeast17() {
        String version = System.getProperty("java.version");
        String javaMajorVersion = version.split("\\.")[0];
        return Integer.parseInt(javaMajorVersion) >= 17;
    }
}

