/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.modules.cryptography.internal.jce.impl;

import com.mulesoft.modules.cryptography.internal.FipsUtils;
import com.mulesoft.modules.cryptography.internal.errors.CryptoErrors;
import com.mulesoft.modules.cryptography.internal.jce.impl.JceKeyImpl;
import java.io.InputStream;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.spec.InvalidKeySpecException;
import java.util.Base64;
import java.util.Optional;
import javax.crypto.Mac;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.PBEParameterSpec;
import org.apache.commons.io.IOUtils;
import org.mule.encryption.Encrypter;
import org.mule.encryption.jce.JCEPbeEncrypter;
import org.mule.encryption.key.EncryptionKeyFactory;
import org.mule.encryption.key.SymmetricKeyFactory;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.extension.api.error.ErrorTypeDefinition;
import org.mule.runtime.extension.api.exception.ModuleException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JcePbeImpl
extends JceKeyImpl {
    private final String password;
    private final Logger LOGGER = LoggerFactory.getLogger(JcePbeImpl.class);

    public JcePbeImpl(String password) {
        this.password = password;
    }

    @Override
    public String sign(InputStream content, String algorithm) {
        try {
            Mac mac = this.createMac(algorithm, this.password);
            byte[] contentBytes = IOUtils.toByteArray((InputStream)content);
            mac.update(contentBytes);
            byte[] result = mac.doFinal();
            return new String(Base64.getEncoder().encode(result));
        }
        catch (ModuleException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ModuleException(I18nMessageFactory.createStaticMessage((String)"Could not encrypt data"), (ErrorTypeDefinition)CryptoErrors.ENCRYPTION, (Throwable)e);
        }
    }

    @Override
    public boolean validate(InputStream value, String expected, String algorithm) {
        String actual = this.sign(value, algorithm);
        return actual.equals(expected);
    }

    @Override
    protected Encrypter encrypter(String algorithm, Optional<Provider> provider) {
        return (Encrypter)provider.map(value -> new JCEPbeEncrypter(algorithm, (EncryptionKeyFactory)((SymmetricKeyFactory)() -> this.getKeyFromPassword(this.password, algorithm, provider)), value)).orElseGet(() -> new JCEPbeEncrypter(algorithm, (EncryptionKeyFactory)((SymmetricKeyFactory)() -> this.getKeyFromPassword(this.password, algorithm, provider))));
    }

    private Mac createMac(String algorithm, String password) throws Exception {
        Optional<Provider> provider = FipsUtils.getBcSecurityProviderIfApplicable();
        Mac mac = provider.isPresent() ? Mac.getInstance(algorithm, provider.get()) : Mac.getInstance(algorithm);
        PBEParameterSpec pbeParameterSpec = new PBEParameterSpec("12345678".getBytes(), 20);
        try {
            Key key = this.getKeyFromPassword(password, "PBE", Optional.empty());
            mac.init(key, pbeParameterSpec);
        }
        catch (Exception e) {
            Key key = this.getKeyFromPassword(password, "PBE", FipsUtils.getBcSecurityProviderIfApplicable());
            mac.init(key, pbeParameterSpec);
        }
        return mac;
    }

    private Key getKeyFromPassword(String password, String name, Optional<Provider> provider) {
        try {
            PBEKeySpec keySpec = new PBEKeySpec(password.toCharArray());
            SecretKeyFactory keyFactory = SecretKeyFactory.getInstance(name);
            if (provider.isPresent()) {
                try {
                    keyFactory = SecretKeyFactory.getInstance(name, provider.get());
                }
                catch (NoSuchAlgorithmException e) {
                    this.LOGGER.debug("Bouncy Castle does not support {}. Re-trying with the next provider on the list.", (Object)name);
                }
            }
            return keyFactory.generateSecret(keySpec);
        }
        catch (NoSuchAlgorithmException | InvalidKeySpecException e) {
            throw new ModuleException(I18nMessageFactory.createStaticMessage((String)"Could not encrypt data"), (ErrorTypeDefinition)CryptoErrors.ENCRYPTION, (Throwable)e);
        }
    }
}

