/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.modules.cryptography.internal.jce.impl;

import com.mulesoft.modules.cryptography.api.jce.config.JceAsymmetricKeyInfo;
import com.mulesoft.modules.cryptography.internal.errors.CryptoErrors;
import com.mulesoft.modules.cryptography.internal.jce.config.JceConfiguration;
import com.mulesoft.modules.cryptography.internal.jce.impl.JceKeyImpl;
import java.io.InputStream;
import java.security.Key;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Signature;
import java.util.Base64;
import java.util.Optional;
import org.mule.encryption.Encrypter;
import org.mule.encryption.jce.JCEEncrypter;
import org.mule.encryption.key.EncryptionKeyFactory;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.core.api.util.IOUtils;
import org.mule.runtime.extension.api.error.ErrorTypeDefinition;
import org.mule.runtime.extension.api.exception.ModuleException;

public class JceAsymmetricKeyImpl
extends JceKeyImpl {
    private JceConfiguration config;
    private JceAsymmetricKeyInfo keyInfo;

    public JceAsymmetricKeyImpl(JceConfiguration config, JceAsymmetricKeyInfo keyInfo) {
        this.config = config;
        this.keyInfo = keyInfo;
    }

    @Override
    public String sign(InputStream content, String algorithm) {
        byte[] inputBytes = IOUtils.toByteArray((InputStream)content);
        try {
            Key key = this.keyInfo.getPrivateKey(this.config.getKeystore());
            Signature signature = Signature.getInstance(algorithm);
            signature.initSign((PrivateKey)key, new SecureRandom());
            signature.update(inputBytes);
            byte[] sigBytes = signature.sign();
            return new String(Base64.getEncoder().encode(sigBytes));
        }
        catch (Exception e) {
            throw new ModuleException(I18nMessageFactory.createStaticMessage((String)"Could not sign data"), (ErrorTypeDefinition)CryptoErrors.SIGNATURE, (Throwable)e);
        }
    }

    @Override
    public boolean validate(InputStream value, String expected, String algorithm) {
        try {
            Key key = this.keyInfo.getPublicKey(this.config.getKeystore());
            byte[] inputBytes = IOUtils.toByteArray((InputStream)value);
            Signature signature = Signature.getInstance(algorithm);
            signature.initVerify((PublicKey)key);
            signature.update(inputBytes);
            return signature.verify(Base64.getDecoder().decode(expected));
        }
        catch (Exception e) {
            throw new ModuleException(I18nMessageFactory.createStaticMessage((String)"Could not validate data"), (ErrorTypeDefinition)CryptoErrors.VALIDATION, (Throwable)e);
        }
    }

    @Override
    protected Encrypter encrypter(String algorithm, Optional<Provider> provider) {
        return (Encrypter)provider.map(value -> new JCEEncrypter(algorithm, this.keyFactory(), false, value)).orElseGet(() -> new JCEEncrypter(algorithm, this.keyFactory(), false));
    }

    private EncryptionKeyFactory keyFactory() {
        return new EncryptionKeyFactory(){

            public Key encryptionKey() {
                return JceAsymmetricKeyImpl.this.keyInfo.getPublicKey(JceAsymmetricKeyImpl.this.config.getKeystore());
            }

            public Key decryptionKey() {
                return JceAsymmetricKeyImpl.this.keyInfo.getPrivateKey(JceAsymmetricKeyImpl.this.config.getKeystore());
            }
        };
    }
}

