/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.modules.cryptography.api.xml.config;

import com.mulesoft.modules.cryptography.api.xml.config.XmlCanonicalizationAlgorithm;
import com.mulesoft.modules.cryptography.api.xml.config.XmlEncryptionAlgorithm;
import com.mulesoft.modules.cryptography.api.xml.config.XmlKeyTransportAlgorithm;
import com.mulesoft.modules.cryptography.api.xml.config.XmlSignDigestAlgorithm;
import com.mulesoft.modules.cryptography.internal.errors.CryptoErrors;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import javax.crypto.KeyGenerator;
import org.apache.xml.security.algorithms.JCEMapper;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.meta.ExpressionSupport;
import org.mule.runtime.extension.api.annotation.Expression;
import org.mule.runtime.extension.api.annotation.param.Optional;
import org.mule.runtime.extension.api.annotation.param.Parameter;
import org.mule.runtime.extension.api.annotation.param.display.DisplayName;
import org.mule.runtime.extension.api.error.ErrorTypeDefinition;
import org.mule.runtime.extension.api.exception.ModuleException;

public class EphemeralKeyInfo {
    @Parameter
    @Optional(defaultValue="RSA_OAEP")
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    private XmlKeyTransportAlgorithm encryptionAlgorithm;
    @Parameter
    @Optional(defaultValue="EXCLUSIVE")
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    @DisplayName(value="Canonicalization algorithm")
    private XmlCanonicalizationAlgorithm c14nAlgorithm;
    @Parameter
    @Optional(defaultValue="SHA1")
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    private XmlSignDigestAlgorithm digestAlgorithm;

    public Key createSymmetricKey(XmlEncryptionAlgorithm encryptionSymAlgorithm) {
        try {
            return this.createKeyGenerator(encryptionSymAlgorithm).generateKey();
        }
        catch (NoSuchAlgorithmException e) {
            throw new ModuleException(I18nMessageFactory.createStaticMessage((String)"Unable to generate symmetric key - ", (Object[])new Object[]{e.getMessage()}), (ErrorTypeDefinition)CryptoErrors.KEY);
        }
    }

    public XmlKeyTransportAlgorithm getEncryptionAlgorithm() {
        return this.encryptionAlgorithm;
    }

    public void setEncryptionAlgorithm(XmlKeyTransportAlgorithm encryptionAlgorithm) {
        this.encryptionAlgorithm = encryptionAlgorithm;
    }

    public XmlCanonicalizationAlgorithm getC14nAlgorithm() {
        return this.c14nAlgorithm;
    }

    public void setC14nAlgorithm(XmlCanonicalizationAlgorithm c14nAlgorithm) {
        this.c14nAlgorithm = c14nAlgorithm;
    }

    public XmlSignDigestAlgorithm getDigestAlgorithm() {
        return this.digestAlgorithm;
    }

    public void setDigestAlgorithm(XmlSignDigestAlgorithm digestAlgorithm) {
        this.digestAlgorithm = digestAlgorithm;
    }

    private KeyGenerator createKeyGenerator(XmlEncryptionAlgorithm encryptionSymAlgorithm) throws NoSuchAlgorithmException {
        String algorithm = encryptionSymAlgorithm.getInfo().getAlgorithm(encryptionSymAlgorithm.getEphemeralKeyLength());
        String keyAlgorithm = JCEMapper.getJCEKeyAlgorithmFromURI((String)algorithm);
        if (keyAlgorithm == null || "".equals(keyAlgorithm)) {
            keyAlgorithm = JCEMapper.translateURItoJCEID((String)algorithm);
        }
        KeyGenerator keyGen = KeyGenerator.getInstance(keyAlgorithm);
        keyGen.init(encryptionSymAlgorithm.getEphemeralKeyLength() * 8);
        return keyGen;
    }
}

