/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.shaded.openpgp.operator.jcajce;

import java.io.OutputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.bouncycastle.shaded.jcajce.io.OutputStreamFactory;
import org.bouncycastle.shaded.openpgp.operator.PGPDigestCalculator;

class SHA1PGPDigestCalculator
implements PGPDigestCalculator {
    private MessageDigest digest;

    SHA1PGPDigestCalculator() {
        try {
            this.digest = MessageDigest.getInstance("SHA1");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new IllegalStateException("cannot find SHA-1: " + noSuchAlgorithmException.getMessage());
        }
    }

    @Override
    public int getAlgorithm() {
        return 2;
    }

    @Override
    public OutputStream getOutputStream() {
        return OutputStreamFactory.createStream(this.digest);
    }

    @Override
    public byte[] getDigest() {
        return this.digest.digest();
    }

    @Override
    public void reset() {
        this.digest.reset();
    }
}

