/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.shaded.openpgp.operator.bc;

import java.io.IOException;
import java.io.OutputStream;
import org.bouncycastle.shaded.crypto.Digest;
import org.bouncycastle.shaded.crypto.digests.SHA1Digest;
import org.bouncycastle.shaded.openpgp.operator.PGPDigestCalculator;

class SHA1PGPDigestCalculator
implements PGPDigestCalculator {
    private Digest digest = new SHA1Digest();

    SHA1PGPDigestCalculator() {
    }

    @Override
    public int getAlgorithm() {
        return 2;
    }

    @Override
    public OutputStream getOutputStream() {
        return new DigestOutputStream(this.digest);
    }

    @Override
    public byte[] getDigest() {
        byte[] byArray = new byte[this.digest.getDigestSize()];
        this.digest.doFinal(byArray, 0);
        return byArray;
    }

    @Override
    public void reset() {
        this.digest.reset();
    }

    private static class DigestOutputStream
    extends OutputStream {
        private Digest dig;

        DigestOutputStream(Digest digest) {
            this.dig = digest;
        }

        @Override
        public void write(byte[] byArray, int n, int n2) throws IOException {
            this.dig.update(byArray, n, n2);
        }

        @Override
        public void write(byte[] byArray) throws IOException {
            this.dig.update(byArray, 0, byArray.length);
        }

        @Override
        public void write(int n) throws IOException {
            this.dig.update((byte)n);
        }
    }
}

