/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.shaded.openpgp.operator.bc;

import java.io.OutputStream;
import java.security.SecureRandom;
import org.bouncycastle.shaded.crypto.CryptoException;
import org.bouncycastle.shaded.crypto.Signer;
import org.bouncycastle.shaded.crypto.params.AsymmetricKeyParameter;
import org.bouncycastle.shaded.crypto.params.ParametersWithRandom;
import org.bouncycastle.shaded.openpgp.PGPException;
import org.bouncycastle.shaded.openpgp.PGPPrivateKey;
import org.bouncycastle.shaded.openpgp.operator.PGPContentSigner;
import org.bouncycastle.shaded.openpgp.operator.PGPContentSignerBuilder;
import org.bouncycastle.shaded.openpgp.operator.PGPDigestCalculator;
import org.bouncycastle.shaded.openpgp.operator.bc.BcImplProvider;
import org.bouncycastle.shaded.openpgp.operator.bc.BcPGPDigestCalculatorProvider;
import org.bouncycastle.shaded.openpgp.operator.bc.BcPGPKeyConverter;
import org.bouncycastle.shaded.openpgp.operator.bc.SignerOutputStream;
import org.bouncycastle.shaded.util.io.TeeOutputStream;

public class BcPGPContentSignerBuilder
implements PGPContentSignerBuilder {
    private BcPGPDigestCalculatorProvider digestCalculatorProvider = new BcPGPDigestCalculatorProvider();
    private BcPGPKeyConverter keyConverter = new BcPGPKeyConverter();
    private int hashAlgorithm;
    private SecureRandom random;
    private int keyAlgorithm;

    public BcPGPContentSignerBuilder(int n, int n2) {
        this.keyAlgorithm = n;
        this.hashAlgorithm = n2;
    }

    public BcPGPContentSignerBuilder setSecureRandom(SecureRandom secureRandom) {
        this.random = secureRandom;
        return this;
    }

    @Override
    public PGPContentSigner build(final int n, final PGPPrivateKey pGPPrivateKey) throws PGPException {
        AsymmetricKeyParameter asymmetricKeyParameter = this.keyConverter.getPrivateKey(pGPPrivateKey);
        final PGPDigestCalculator pGPDigestCalculator = this.digestCalculatorProvider.get(this.hashAlgorithm);
        final Signer signer = BcImplProvider.createSigner(this.keyAlgorithm, this.hashAlgorithm, asymmetricKeyParameter);
        if (this.random != null) {
            signer.init(true, new ParametersWithRandom(asymmetricKeyParameter, this.random));
        } else {
            signer.init(true, asymmetricKeyParameter);
        }
        return new PGPContentSigner(){

            @Override
            public int getType() {
                return n;
            }

            @Override
            public int getHashAlgorithm() {
                return BcPGPContentSignerBuilder.this.hashAlgorithm;
            }

            @Override
            public int getKeyAlgorithm() {
                return BcPGPContentSignerBuilder.this.keyAlgorithm;
            }

            @Override
            public long getKeyID() {
                return pGPPrivateKey.getKeyID();
            }

            @Override
            public OutputStream getOutputStream() {
                return new TeeOutputStream(new SignerOutputStream(signer), pGPDigestCalculator.getOutputStream());
            }

            @Override
            public byte[] getSignature() {
                try {
                    return signer.generateSignature();
                }
                catch (CryptoException cryptoException) {
                    throw new IllegalStateException("unable to create signature");
                }
            }

            @Override
            public byte[] getDigest() {
                return pGPDigestCalculator.getDigest();
            }
        };
    }
}

