/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.shaded.openpgp.operator;

import java.security.SecureRandom;
import org.bouncycastle.shaded.bcpg.S2K;
import org.bouncycastle.shaded.openpgp.PGPException;
import org.bouncycastle.shaded.openpgp.operator.PGPDigestCalculator;
import org.bouncycastle.shaded.openpgp.operator.PGPUtil;

public abstract class PBESecretKeyEncryptor {
    protected int encAlgorithm;
    protected char[] passPhrase;
    protected PGPDigestCalculator s2kDigestCalculator;
    protected int s2kCount;
    protected S2K s2k;
    protected SecureRandom random;

    protected PBESecretKeyEncryptor(int n, PGPDigestCalculator pGPDigestCalculator, SecureRandom secureRandom, char[] cArray) {
        this(n, pGPDigestCalculator, 96, secureRandom, cArray);
    }

    protected PBESecretKeyEncryptor(int n, PGPDigestCalculator pGPDigestCalculator, int n2, SecureRandom secureRandom, char[] cArray) {
        this.encAlgorithm = n;
        this.passPhrase = cArray;
        this.random = secureRandom;
        this.s2kDigestCalculator = pGPDigestCalculator;
        if (n2 < 0 || n2 > 255) {
            throw new IllegalArgumentException("s2kCount value outside of range 0 to 255.");
        }
        this.s2kCount = n2;
    }

    public int getAlgorithm() {
        return this.encAlgorithm;
    }

    public int getHashAlgorithm() {
        if (this.s2kDigestCalculator != null) {
            return this.s2kDigestCalculator.getAlgorithm();
        }
        return -1;
    }

    public byte[] getKey() throws PGPException {
        return PGPUtil.makeKeyFromPassPhrase(this.s2kDigestCalculator, this.encAlgorithm, this.s2k, this.passPhrase);
    }

    public S2K getS2K() {
        return this.s2k;
    }

    public byte[] encryptKeyData(byte[] byArray, int n, int n2) throws PGPException {
        if (this.s2k == null) {
            byte[] byArray2 = new byte[8];
            this.random.nextBytes(byArray2);
            this.s2k = new S2K(this.s2kDigestCalculator.getAlgorithm(), byArray2, this.s2kCount);
        }
        return this.encryptKeyData(this.getKey(), byArray, n, n2);
    }

    public abstract byte[] encryptKeyData(byte[] var1, byte[] var2, int var3, int var4) throws PGPException;

    public byte[] encryptKeyData(byte[] byArray, byte[] byArray2, byte[] byArray3, int n, int n2) throws PGPException {
        throw new PGPException("encryption of version 3 keys not supported.");
    }

    public abstract byte[] getCipherIV();
}

