/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.modules.cryptography.internal.pgp;

import com.mulesoft.modules.cryptography.api.pgp.config.PgpEncryptionAlgorithm;
import com.mulesoft.modules.cryptography.api.pgp.config.PgpKeySelection;
import com.mulesoft.modules.cryptography.api.pgp.config.PgpSignatureAlgorithm;
import com.mulesoft.modules.cryptography.internal.FipsUtils;
import com.mulesoft.modules.cryptography.internal.errors.CryptoErrors;
import com.mulesoft.modules.cryptography.internal.errors.DecryptionErrorTypeProvider;
import com.mulesoft.modules.cryptography.internal.errors.EncryptionErrorTypeProvider;
import com.mulesoft.modules.cryptography.internal.errors.ParametersErrorTypeProvider;
import com.mulesoft.modules.cryptography.internal.errors.SignatureErrorTypeProvider;
import com.mulesoft.modules.cryptography.internal.errors.ValidationErrorTypeProvider;
import com.mulesoft.modules.cryptography.internal.pgp.PgpEncrypter;
import com.mulesoft.modules.cryptography.internal.pgp.PgpSigner;
import com.mulesoft.modules.cryptography.internal.pgp.PgpTransformer;
import com.mulesoft.modules.cryptography.internal.pgp.config.PgpConfiguration;
import java.io.InputStream;
import java.util.Optional;
import javax.inject.Inject;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.lifecycle.Startable;
import org.mule.runtime.api.lifecycle.Stoppable;
import org.mule.runtime.api.meta.model.operation.ExecutionType;
import org.mule.runtime.api.scheduler.Scheduler;
import org.mule.runtime.api.scheduler.SchedulerService;
import org.mule.runtime.extension.api.annotation.error.Throws;
import org.mule.runtime.extension.api.annotation.execution.Execution;
import org.mule.runtime.extension.api.annotation.param.Config;
import org.mule.runtime.extension.api.annotation.param.Content;
import org.mule.runtime.extension.api.annotation.param.MediaType;
import org.mule.runtime.extension.api.annotation.param.ParameterGroup;
import org.mule.runtime.extension.api.annotation.param.display.Summary;
import org.mule.runtime.extension.api.annotation.param.stereotype.Validator;
import org.mule.runtime.extension.api.error.ErrorTypeDefinition;
import org.mule.runtime.extension.api.exception.ModuleException;

public class PgpOperations
implements Startable,
Stoppable {
    @Inject
    private SchedulerService schedulerService;
    private Scheduler scheduler;
    private final String DISABLE_MDC_SUMMARY = "If set, MDC (modification detection code) will not be used during encryption";

    @MediaType(value="text/plain")
    @Throws(value={EncryptionErrorTypeProvider.class})
    @Execution(value=ExecutionType.CPU_INTENSIVE)
    public InputStream pgpEncrypt(@Config PgpConfiguration config, @Content InputStream content, @org.mule.runtime.extension.api.annotation.param.Optional(defaultValue="AES_256") PgpEncryptionAlgorithm algorithm, @org.mule.runtime.extension.api.annotation.param.Optional(defaultValue="stream") String fileName, @ParameterGroup(name="Key selection") PgpKeySelection keySelection, @Summary(value="If set, MDC (modification detection code) will not be used during encryption") @org.mule.runtime.extension.api.annotation.param.Optional(defaultValue="false") boolean disableMDC) {
        return FipsUtils.executeWithinSecurityProvider(() -> new PgpEncrypter(config).encrypt(content, fileName, keySelection.getKeyInfo(config), algorithm, disableMDC, this.scheduler, true));
    }

    @Summary(value="Performs an atomic encrypt and sign over a given payload. This lets an encrypted message carry a integrity check (the signature) over its contents.")
    @MediaType(value="text/plain")
    @Throws(value={EncryptionErrorTypeProvider.class})
    @Execution(value=ExecutionType.CPU_INTENSIVE)
    public InputStream pgpEncryptAndSign(@Config PgpConfiguration config, @Content InputStream content, @org.mule.runtime.extension.api.annotation.param.Optional(defaultValue="AES_256") PgpEncryptionAlgorithm algorithm, @org.mule.runtime.extension.api.annotation.param.Optional(defaultValue="stream") String fileName, @Summary(value="The recipients public key that will be used to encrypt the message") PgpKeySelection encryptionKeySelection, @Summary(value="The senders private key that will be used to sign the message") PgpKeySelection signKeySelection, @Summary(value="If set, MDC (modification detection code) will not be used during encryption") @org.mule.runtime.extension.api.annotation.param.Optional(defaultValue="false") boolean disableMDC) {
        return FipsUtils.executeWithinSecurityProvider(() -> new PgpEncrypter(config).encrypt(content, fileName, encryptionKeySelection.getKeyInfo(config), algorithm, Optional.of(signKeySelection.getKeyInfo(config)), disableMDC, this.scheduler, true));
    }

    @MediaType(value="application/octet-stream", strict=false)
    @Throws(value={EncryptionErrorTypeProvider.class})
    @Execution(value=ExecutionType.CPU_INTENSIVE)
    public InputStream pgpEncryptBinary(@Config PgpConfiguration config, @Content InputStream content, @org.mule.runtime.extension.api.annotation.param.Optional(defaultValue="AES_256") PgpEncryptionAlgorithm algorithm, @org.mule.runtime.extension.api.annotation.param.Optional(defaultValue="stream") String fileName, @ParameterGroup(name="Key selection") PgpKeySelection keySelection, @Summary(value="If set, MDC (modification detection code) will not be used during encryption") @org.mule.runtime.extension.api.annotation.param.Optional(defaultValue="false") boolean disableMDC) {
        return FipsUtils.executeWithinSecurityProvider(() -> new PgpEncrypter(config).encrypt(content, fileName, keySelection.getKeyInfo(config), algorithm, disableMDC, this.scheduler, false));
    }

    @MediaType(value="application/octet-stream", strict=false)
    @Throws(value={DecryptionErrorTypeProvider.class})
    @Execution(value=ExecutionType.CPU_INTENSIVE)
    public InputStream pgpDecrypt(@Config PgpConfiguration config, @Content @org.mule.runtime.extension.api.annotation.param.Optional(defaultValue="#[payload]") InputStream content, @org.mule.runtime.extension.api.annotation.param.Optional String fileName, @org.mule.runtime.extension.api.annotation.param.Optional(defaultValue="false") @Summary(value="If the message being decrypted contains a signature, choose whether or not to validate the decrypted message against it") boolean validateIfSignatureFound) {
        return FipsUtils.executeWithinSecurityProvider(() -> new PgpEncrypter(config).decrypt(content, fileName, validateIfSignatureFound));
    }

    @MediaType(value="text/plain")
    @Throws(value={SignatureErrorTypeProvider.class})
    @Execution(value=ExecutionType.CPU_INTENSIVE)
    public InputStream pgpSign(@Config PgpConfiguration config, @Content InputStream content, @org.mule.runtime.extension.api.annotation.param.Optional(defaultValue="SHA256") PgpSignatureAlgorithm algorithm, @ParameterGroup(name="Key selection") PgpKeySelection keySelection) {
        return FipsUtils.executeWithinSecurityProvider(() -> PgpTransformer.binaryToArmored(new PgpSigner(config).sign(content, keySelection.getKeyInfo(config), algorithm)));
    }

    @MediaType(value="application/octet-stream", strict=false)
    @Throws(value={SignatureErrorTypeProvider.class})
    @Execution(value=ExecutionType.CPU_INTENSIVE)
    public InputStream pgpSignBinary(@Config PgpConfiguration config, @Content InputStream content, @org.mule.runtime.extension.api.annotation.param.Optional(defaultValue="SHA256") PgpSignatureAlgorithm algorithm, @ParameterGroup(name="Key selection") PgpKeySelection keySelection) {
        return FipsUtils.executeWithinSecurityProvider(() -> new PgpSigner(config).sign(content, keySelection.getKeyInfo(config), algorithm));
    }

    @Validator
    @Throws(value={ValidationErrorTypeProvider.class})
    @Execution(value=ExecutionType.CPU_INTENSIVE)
    public void pgpValidate(@Config PgpConfiguration config, @org.mule.runtime.extension.api.annotation.param.Optional(defaultValue="#[payload]") InputStream value, InputStream expected) {
        boolean isVerified = FipsUtils.executeWithinSecurityProvider(() -> new PgpSigner(config).validate(value, expected));
        if (!isVerified) {
            throw new ModuleException(I18nMessageFactory.createStaticMessage((String)"PGP signature verification failed"), (ErrorTypeDefinition)CryptoErrors.VALIDATION);
        }
    }

    @MediaType(value="text/plain")
    @Throws(value={ParametersErrorTypeProvider.class})
    @Execution(value=ExecutionType.CPU_INTENSIVE)
    public InputStream pgpBinaryToArmored(@Content InputStream content) {
        return PgpTransformer.binaryToArmored(content);
    }

    public void start() throws MuleException {
        this.scheduler = this.schedulerService.cpuIntensiveScheduler();
    }

    public void stop() throws MuleException {
        this.scheduler.stop();
        this.scheduler = null;
    }
}

