/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.modules.cryptography.api.xml.config;

import com.mulesoft.modules.cryptography.internal.errors.CryptoErrors;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.extension.api.error.ErrorTypeDefinition;
import org.mule.runtime.extension.api.exception.ModuleException;

public enum XmlEncryptionAlgorithm {
    AES_CBC("AES", new AesAlgorithmInfo(false), 32),
    AES_GCM("AES", new AesAlgorithmInfo(true), 32),
    TRIPLEDES("TRIPLEDES", new ConstantAlgorithmInfo("http://www.w3.org/2001/04/xmlenc#tripledes-cbc", "http://www.w3.org/2001/04/xmlenc#kw-tripledes"), 21);

    private final String algorithm;
    private final XmlAlgorithmInfo info;
    private final Integer ephemeralKeySize;

    private XmlEncryptionAlgorithm(String algorithm, XmlAlgorithmInfo info, int ephemeralKeySize) {
        this.algorithm = algorithm;
        this.info = info;
        this.ephemeralKeySize = ephemeralKeySize;
    }

    public String getAlgorithm() {
        return this.algorithm;
    }

    public XmlAlgorithmInfo getInfo() {
        return this.info;
    }

    public Integer getEphemeralKeyLength() {
        return this.ephemeralKeySize;
    }

    static class ConstantAlgorithmInfo
    implements XmlAlgorithmInfo {
        private String algorithm;
        private String keyWrap;

        ConstantAlgorithmInfo(String algorithm, String keyWrap) {
            this.algorithm = algorithm;
            this.keyWrap = keyWrap;
        }

        @Override
        public String getAlgorithm(int keySize) {
            return this.algorithm;
        }

        @Override
        public String getKeyWrap(int keySize) {
            return this.keyWrap;
        }
    }

    static class AesAlgorithmInfo
    implements XmlAlgorithmInfo {
        private boolean isGCM;

        public AesAlgorithmInfo(boolean isGCM) {
            this.isGCM = isGCM;
        }

        @Override
        public String getAlgorithm(int keySize) {
            switch (keySize * 8) {
                case 128: {
                    return this.isGCM ? "http://www.w3.org/2009/xmlenc11#aes128-gcm" : "http://www.w3.org/2001/04/xmlenc#aes128-cbc";
                }
                case 192: {
                    return this.isGCM ? "http://www.w3.org/2009/xmlenc11#aes192-gcm" : "http://www.w3.org/2001/04/xmlenc#aes192-cbc";
                }
                case 256: {
                    return this.isGCM ? "http://www.w3.org/2009/xmlenc11#aes256-gcm" : "http://www.w3.org/2001/04/xmlenc#aes256-cbc";
                }
            }
            throw new ModuleException(I18nMessageFactory.createStaticMessage((String)"AES is only supported for keys of 128, 192 and 256 bits"), (ErrorTypeDefinition)CryptoErrors.KEY);
        }

        @Override
        public String getKeyWrap(int keySize) {
            switch (keySize) {
                case 128: {
                    return "http://www.w3.org/2001/04/xmlenc#kw-aes128";
                }
                case 192: {
                    return "http://www.w3.org/2001/04/xmlenc#kw-aes192";
                }
                case 256: {
                    return "http://www.w3.org/2001/04/xmlenc#kw-aes256";
                }
            }
            throw new ModuleException(I18nMessageFactory.createStaticMessage((String)"AES is only supported for keys of 128, 192 and 256 bits"), (ErrorTypeDefinition)CryptoErrors.KEY);
        }
    }

    public static interface XmlAlgorithmInfo {
        public String getAlgorithm(int var1);

        public String getKeyWrap(int var1);
    }
}

