/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.shaded.pqc.jcajce.provider.saber;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.security.PublicKey;
import org.bouncycastle.shaded.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.shaded.pqc.crypto.saber.SABERPublicKeyParameters;
import org.bouncycastle.shaded.pqc.crypto.util.PublicKeyFactory;
import org.bouncycastle.shaded.pqc.crypto.util.SubjectPublicKeyInfoFactory;
import org.bouncycastle.shaded.pqc.jcajce.interfaces.SABERKey;
import org.bouncycastle.shaded.pqc.jcajce.spec.SABERParameterSpec;
import org.bouncycastle.shaded.util.Arrays;

public class BCSABERPublicKey
implements PublicKey,
SABERKey {
    private static final long serialVersionUID = 1L;
    private transient SABERPublicKeyParameters params;

    public BCSABERPublicKey(SABERPublicKeyParameters sABERPublicKeyParameters) {
        this.params = sABERPublicKeyParameters;
    }

    public BCSABERPublicKey(SubjectPublicKeyInfo subjectPublicKeyInfo) throws IOException {
        this.init(subjectPublicKeyInfo);
    }

    private void init(SubjectPublicKeyInfo subjectPublicKeyInfo) throws IOException {
        this.params = (SABERPublicKeyParameters)PublicKeyFactory.createKey(subjectPublicKeyInfo);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof BCSABERPublicKey) {
            BCSABERPublicKey bCSABERPublicKey = (BCSABERPublicKey)object;
            return Arrays.areEqual(this.params.getEncoded(), bCSABERPublicKey.params.getEncoded());
        }
        return false;
    }

    public int hashCode() {
        return Arrays.hashCode(this.params.getEncoded());
    }

    public final String getAlgorithm() {
        return "SABER";
    }

    public byte[] getEncoded() {
        try {
            SubjectPublicKeyInfo subjectPublicKeyInfo = SubjectPublicKeyInfoFactory.createSubjectPublicKeyInfo(this.params);
            return subjectPublicKeyInfo.getEncoded();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public String getFormat() {
        return "X.509";
    }

    public SABERParameterSpec getParameterSpec() {
        return SABERParameterSpec.fromName(this.params.getParameters().getName());
    }

    SABERPublicKeyParameters getKeyParams() {
        return this.params;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        byte[] byArray = (byte[])objectInputStream.readObject();
        this.init(SubjectPublicKeyInfo.getInstance(byArray));
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeObject(this.getEncoded());
    }
}

