/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.shaded.pqc.crypto.frodo;

import org.bouncycastle.shaded.crypto.BufferedBlockCipher;
import org.bouncycastle.shaded.crypto.InvalidCipherTextException;
import org.bouncycastle.shaded.crypto.digests.SHAKEDigest;
import org.bouncycastle.shaded.crypto.engines.AESEngine;
import org.bouncycastle.shaded.crypto.params.KeyParameter;
import org.bouncycastle.shaded.util.Arrays;
import org.bouncycastle.shaded.util.Exceptions;
import org.bouncycastle.shaded.util.Pack;

abstract class FrodoMatrixGenerator {
    int n;
    int q;

    public FrodoMatrixGenerator(int n, int n2) {
        this.n = n;
        this.q = n2;
    }

    abstract short[] genMatrix(byte[] var1);

    static class Aes128MatrixGenerator
    extends FrodoMatrixGenerator {
        BufferedBlockCipher cipher = new BufferedBlockCipher(new AESEngine());

        public Aes128MatrixGenerator(int n, int n2) {
            super(n, n2);
        }

        short[] genMatrix(byte[] byArray) {
            short[] sArray = new short[this.n * this.n];
            byte[] byArray2 = new byte[16];
            byte[] byArray3 = new byte[16];
            for (int i = 0; i < this.n; ++i) {
                for (int j = 0; j < this.n; j += 8) {
                    System.arraycopy(Pack.shortToLittleEndian((short)(i & 0xFFFF)), 0, byArray2, 0, 2);
                    System.arraycopy(Pack.shortToLittleEndian((short)(j & 0xFFFF)), 0, byArray2, 2, 2);
                    this.aes128(byArray3, byArray, byArray2);
                    for (int k = 0; k < 8; ++k) {
                        sArray[i * this.n + j + k] = (short)(Pack.littleEndianToShort(byArray3, 2 * k) % this.q);
                    }
                }
            }
            return sArray;
        }

        void aes128(byte[] byArray, byte[] byArray2, byte[] byArray3) {
            try {
                KeyParameter keyParameter = new KeyParameter(byArray2);
                this.cipher.init(true, keyParameter);
                int n = this.cipher.processBytes(byArray3, 0, byArray3.length, byArray, 0);
                this.cipher.doFinal(byArray, n);
            }
            catch (InvalidCipherTextException invalidCipherTextException) {
                throw Exceptions.illegalStateException(invalidCipherTextException.toString(), invalidCipherTextException);
            }
        }
    }

    static class Shake128MatrixGenerator
    extends FrodoMatrixGenerator {
        public Shake128MatrixGenerator(int n, int n2) {
            super(n, n2);
        }

        short[] genMatrix(byte[] byArray) {
            short[] sArray = new short[this.n * this.n];
            byte[] byArray2 = new byte[16 * this.n / 8];
            for (short s = 0; s < this.n; s = (short)(s + 1)) {
                byte[] byArray3 = Arrays.concatenate(Pack.shortToLittleEndian(s), byArray);
                SHAKEDigest sHAKEDigest = new SHAKEDigest(128);
                sHAKEDigest.update(byArray3, 0, byArray3.length);
                sHAKEDigest.doFinal(byArray2, 0, byArray2.length);
                for (int n = 0; n < this.n; n = (int)((short)(n + 1))) {
                    sArray[s * this.n + n] = (short)(Pack.littleEndianToShort(byArray2, 2 * n) % this.q);
                }
            }
            return sArray;
        }
    }
}

