/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.shaded.operator.bc;

import java.io.IOException;
import org.bouncycastle.shaded.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.shaded.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.shaded.crypto.ExtendedDigest;
import org.bouncycastle.shaded.crypto.Signer;
import org.bouncycastle.shaded.crypto.params.AsymmetricKeyParameter;
import org.bouncycastle.shaded.crypto.signers.DSADigestSigner;
import org.bouncycastle.shaded.crypto.signers.DSASigner;
import org.bouncycastle.shaded.crypto.util.PublicKeyFactory;
import org.bouncycastle.shaded.operator.DigestAlgorithmIdentifierFinder;
import org.bouncycastle.shaded.operator.OperatorCreationException;
import org.bouncycastle.shaded.operator.bc.BcContentVerifierProviderBuilder;

public class BcDSAContentVerifierProviderBuilder
extends BcContentVerifierProviderBuilder {
    private DigestAlgorithmIdentifierFinder digestAlgorithmFinder;

    public BcDSAContentVerifierProviderBuilder(DigestAlgorithmIdentifierFinder digestAlgorithmIdentifierFinder) {
        this.digestAlgorithmFinder = digestAlgorithmIdentifierFinder;
    }

    protected Signer createSigner(AlgorithmIdentifier algorithmIdentifier) throws OperatorCreationException {
        AlgorithmIdentifier algorithmIdentifier2 = this.digestAlgorithmFinder.find(algorithmIdentifier);
        ExtendedDigest extendedDigest = this.digestProvider.get(algorithmIdentifier2);
        return new DSADigestSigner(new DSASigner(), extendedDigest);
    }

    protected AsymmetricKeyParameter extractKeyParameters(SubjectPublicKeyInfo subjectPublicKeyInfo) throws IOException {
        return PublicKeyFactory.createKey(subjectPublicKeyInfo);
    }
}

