/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.shaded.openpgp.operator.jcajce;

import java.io.IOException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import org.bouncycastle.shaded.bcpg.BCPGKey;
import org.bouncycastle.shaded.bcpg.MPInteger;
import org.bouncycastle.shaded.bcpg.PublicKeyPacket;
import org.bouncycastle.shaded.bcpg.RSAPublicBCPGKey;
import org.bouncycastle.shaded.jcajce.util.DefaultJcaJceHelper;
import org.bouncycastle.shaded.jcajce.util.JcaJceHelper;
import org.bouncycastle.shaded.jcajce.util.NamedJcaJceHelper;
import org.bouncycastle.shaded.jcajce.util.ProviderJcaJceHelper;
import org.bouncycastle.shaded.openpgp.PGPException;
import org.bouncycastle.shaded.openpgp.operator.KeyFingerPrintCalculator;

public class JcaKeyFingerprintCalculator
implements KeyFingerPrintCalculator {
    private final JcaJceHelper helper;

    public JcaKeyFingerprintCalculator() {
        this(new DefaultJcaJceHelper());
    }

    private JcaKeyFingerprintCalculator(JcaJceHelper jcaJceHelper) {
        this.helper = jcaJceHelper;
    }

    public JcaKeyFingerprintCalculator setProvider(Provider provider) {
        return new JcaKeyFingerprintCalculator(new ProviderJcaJceHelper(provider));
    }

    public JcaKeyFingerprintCalculator setProvider(String string) {
        return new JcaKeyFingerprintCalculator(new NamedJcaJceHelper(string));
    }

    public byte[] calculateFingerprint(PublicKeyPacket publicKeyPacket) throws PGPException {
        BCPGKey bCPGKey = publicKeyPacket.getKey();
        if (publicKeyPacket.getVersion() <= 3) {
            RSAPublicBCPGKey rSAPublicBCPGKey = (RSAPublicBCPGKey)bCPGKey;
            try {
                MessageDigest messageDigest = this.helper.createMessageDigest("MD5");
                byte[] byArray = new MPInteger(rSAPublicBCPGKey.getModulus()).getEncoded();
                messageDigest.update(byArray, 2, byArray.length - 2);
                byArray = new MPInteger(rSAPublicBCPGKey.getPublicExponent()).getEncoded();
                messageDigest.update(byArray, 2, byArray.length - 2);
                return messageDigest.digest();
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                throw new PGPException("can't find MD5", noSuchAlgorithmException);
            }
            catch (NoSuchProviderException noSuchProviderException) {
                throw new PGPException("can't find MD5", noSuchProviderException);
            }
            catch (IOException iOException) {
                throw new PGPException("can't encode key components: " + iOException.getMessage(), iOException);
            }
        }
        try {
            byte[] byArray = publicKeyPacket.getEncodedContents();
            MessageDigest messageDigest = this.helper.createMessageDigest("SHA1");
            messageDigest.update((byte)-103);
            messageDigest.update((byte)(byArray.length >> 8));
            messageDigest.update((byte)byArray.length);
            messageDigest.update(byArray);
            return messageDigest.digest();
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new PGPException("can't find SHA1", noSuchAlgorithmException);
        }
        catch (NoSuchProviderException noSuchProviderException) {
            throw new PGPException("can't find SHA1", noSuchProviderException);
        }
        catch (IOException iOException) {
            throw new PGPException("can't encode key components: " + iOException.getMessage(), iOException);
        }
    }
}

