/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.shaded.openpgp.operator.bc;

import java.io.OutputStream;
import java.security.SecureRandom;
import org.bouncycastle.shaded.crypto.BlockCipher;
import org.bouncycastle.shaded.crypto.BufferedBlockCipher;
import org.bouncycastle.shaded.crypto.io.CipherOutputStream;
import org.bouncycastle.shaded.openpgp.PGPException;
import org.bouncycastle.shaded.openpgp.operator.PGPDataEncryptor;
import org.bouncycastle.shaded.openpgp.operator.PGPDataEncryptorBuilder;
import org.bouncycastle.shaded.openpgp.operator.PGPDigestCalculator;
import org.bouncycastle.shaded.openpgp.operator.bc.BcImplProvider;
import org.bouncycastle.shaded.openpgp.operator.bc.BcUtil;
import org.bouncycastle.shaded.openpgp.operator.bc.SHA1PGPDigestCalculator;

public class BcPGPDataEncryptorBuilder
implements PGPDataEncryptorBuilder {
    private SecureRandom random;
    private boolean withIntegrityPacket;
    private int encAlgorithm;

    public BcPGPDataEncryptorBuilder(int n) {
        this.encAlgorithm = n;
        if (n == 0) {
            throw new IllegalArgumentException("null cipher specified");
        }
    }

    public BcPGPDataEncryptorBuilder setWithIntegrityPacket(boolean bl) {
        this.withIntegrityPacket = bl;
        return this;
    }

    public BcPGPDataEncryptorBuilder setSecureRandom(SecureRandom secureRandom) {
        this.random = secureRandom;
        return this;
    }

    public int getAlgorithm() {
        return this.encAlgorithm;
    }

    public SecureRandom getSecureRandom() {
        if (this.random == null) {
            this.random = new SecureRandom();
        }
        return this.random;
    }

    public PGPDataEncryptor build(byte[] byArray) throws PGPException {
        return new MyPGPDataEncryptor(byArray);
    }

    private class MyPGPDataEncryptor
    implements PGPDataEncryptor {
        private final BufferedBlockCipher c;

        MyPGPDataEncryptor(byte[] byArray) throws PGPException {
            BlockCipher blockCipher = BcImplProvider.createBlockCipher(BcPGPDataEncryptorBuilder.this.encAlgorithm);
            try {
                this.c = BcUtil.createStreamCipher(true, blockCipher, BcPGPDataEncryptorBuilder.this.withIntegrityPacket, byArray);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new PGPException("invalid parameters: " + illegalArgumentException.getMessage(), illegalArgumentException);
            }
        }

        public OutputStream getOutputStream(OutputStream outputStream) {
            return new CipherOutputStream(outputStream, this.c);
        }

        public PGPDigestCalculator getIntegrityCalculator() {
            if (BcPGPDataEncryptorBuilder.this.withIntegrityPacket) {
                return new SHA1PGPDigestCalculator();
            }
            return null;
        }

        public int getBlockSize() {
            return this.c.getBlockSize();
        }
    }
}

