/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.shaded.openpgp.operator.bc;

import org.bouncycastle.shaded.crypto.AsymmetricBlockCipher;
import org.bouncycastle.shaded.crypto.BlockCipher;
import org.bouncycastle.shaded.crypto.CipherParameters;
import org.bouncycastle.shaded.crypto.CryptoException;
import org.bouncycastle.shaded.crypto.DataLengthException;
import org.bouncycastle.shaded.crypto.Digest;
import org.bouncycastle.shaded.crypto.Signer;
import org.bouncycastle.shaded.crypto.Wrapper;
import org.bouncycastle.shaded.crypto.digests.MD2Digest;
import org.bouncycastle.shaded.crypto.digests.MD5Digest;
import org.bouncycastle.shaded.crypto.digests.RIPEMD160Digest;
import org.bouncycastle.shaded.crypto.digests.SHA1Digest;
import org.bouncycastle.shaded.crypto.digests.SHA224Digest;
import org.bouncycastle.shaded.crypto.digests.SHA256Digest;
import org.bouncycastle.shaded.crypto.digests.SHA384Digest;
import org.bouncycastle.shaded.crypto.digests.SHA512Digest;
import org.bouncycastle.shaded.crypto.digests.TigerDigest;
import org.bouncycastle.shaded.crypto.encodings.PKCS1Encoding;
import org.bouncycastle.shaded.crypto.engines.AESEngine;
import org.bouncycastle.shaded.crypto.engines.BlowfishEngine;
import org.bouncycastle.shaded.crypto.engines.CAST5Engine;
import org.bouncycastle.shaded.crypto.engines.CamelliaEngine;
import org.bouncycastle.shaded.crypto.engines.DESEngine;
import org.bouncycastle.shaded.crypto.engines.DESedeEngine;
import org.bouncycastle.shaded.crypto.engines.ElGamalEngine;
import org.bouncycastle.shaded.crypto.engines.IDEAEngine;
import org.bouncycastle.shaded.crypto.engines.RFC3394WrapEngine;
import org.bouncycastle.shaded.crypto.engines.RSABlindedEngine;
import org.bouncycastle.shaded.crypto.engines.TwofishEngine;
import org.bouncycastle.shaded.crypto.params.Ed25519PrivateKeyParameters;
import org.bouncycastle.shaded.crypto.params.Ed25519PublicKeyParameters;
import org.bouncycastle.shaded.crypto.signers.DSADigestSigner;
import org.bouncycastle.shaded.crypto.signers.DSASigner;
import org.bouncycastle.shaded.crypto.signers.ECDSASigner;
import org.bouncycastle.shaded.crypto.signers.Ed25519Signer;
import org.bouncycastle.shaded.crypto.signers.Ed448Signer;
import org.bouncycastle.shaded.crypto.signers.RSADigestSigner;
import org.bouncycastle.shaded.openpgp.PGPException;
import org.bouncycastle.shaded.util.Arrays;

class BcImplProvider {
    BcImplProvider() {
    }

    static Digest createDigest(int n) throws PGPException {
        switch (n) {
            case 2: {
                return new SHA1Digest();
            }
            case 11: {
                return new SHA224Digest();
            }
            case 8: {
                return new SHA256Digest();
            }
            case 9: {
                return new SHA384Digest();
            }
            case 10: {
                return new SHA512Digest();
            }
            case 5: {
                return new MD2Digest();
            }
            case 1: {
                return new MD5Digest();
            }
            case 3: {
                return new RIPEMD160Digest();
            }
            case 6: {
                return new TigerDigest();
            }
        }
        throw new PGPException("cannot recognise digest");
    }

    static Signer createSigner(int n, int n2, CipherParameters cipherParameters) throws PGPException {
        switch (n) {
            case 1: 
            case 3: {
                return new RSADigestSigner(BcImplProvider.createDigest(n2));
            }
            case 17: {
                return new DSADigestSigner(new DSASigner(), BcImplProvider.createDigest(n2));
            }
            case 19: {
                return new DSADigestSigner(new ECDSASigner(), BcImplProvider.createDigest(n2));
            }
            case 22: {
                if (cipherParameters instanceof Ed25519PrivateKeyParameters || cipherParameters instanceof Ed25519PublicKeyParameters) {
                    return new EdDsaSigner(new Ed25519Signer(), BcImplProvider.createDigest(n2));
                }
                return new EdDsaSigner(new Ed448Signer(new byte[0]), BcImplProvider.createDigest(n2));
            }
        }
        throw new PGPException("cannot recognise keyAlgorithm: " + n);
    }

    static BlockCipher createBlockCipher(int n) throws PGPException {
        BlockCipher blockCipher;
        switch (n) {
            case 7: 
            case 8: 
            case 9: {
                blockCipher = new AESEngine();
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                blockCipher = new CamelliaEngine();
                break;
            }
            case 4: {
                blockCipher = new BlowfishEngine();
                break;
            }
            case 3: {
                blockCipher = new CAST5Engine();
                break;
            }
            case 6: {
                blockCipher = new DESEngine();
                break;
            }
            case 1: {
                blockCipher = new IDEAEngine();
                break;
            }
            case 10: {
                blockCipher = new TwofishEngine();
                break;
            }
            case 2: {
                blockCipher = new DESedeEngine();
                break;
            }
            default: {
                throw new PGPException("cannot recognise cipher");
            }
        }
        return blockCipher;
    }

    static Wrapper createWrapper(int n) throws PGPException {
        switch (n) {
            case 7: 
            case 8: 
            case 9: {
                return new RFC3394WrapEngine(new AESEngine());
            }
            case 11: 
            case 12: 
            case 13: {
                return new RFC3394WrapEngine(new CamelliaEngine());
            }
        }
        throw new PGPException("unknown wrap algorithm: " + n);
    }

    static AsymmetricBlockCipher createPublicKeyCipher(int n) throws PGPException {
        PKCS1Encoding pKCS1Encoding;
        switch (n) {
            case 1: 
            case 2: {
                pKCS1Encoding = new PKCS1Encoding(new RSABlindedEngine());
                break;
            }
            case 16: 
            case 20: {
                pKCS1Encoding = new PKCS1Encoding(new ElGamalEngine());
                break;
            }
            case 17: {
                throw new PGPException("Can't use DSA for encryption.");
            }
            case 19: {
                throw new PGPException("Can't use ECDSA for encryption.");
            }
            case 18: {
                throw new PGPException("Not implemented.");
            }
            default: {
                throw new PGPException("unknown asymmetric algorithm: " + n);
            }
        }
        return pKCS1Encoding;
    }

    private static class EdDsaSigner
    implements Signer {
        private final Signer signer;
        private final Digest digest;
        private final byte[] digBuf;

        EdDsaSigner(Signer signer, Digest digest) {
            this.signer = signer;
            this.digest = digest;
            this.digBuf = new byte[digest.getDigestSize()];
        }

        public void init(boolean bl, CipherParameters cipherParameters) {
            this.signer.init(bl, cipherParameters);
            this.digest.reset();
        }

        public void update(byte by) {
            this.digest.update(by);
        }

        public void update(byte[] byArray, int n, int n2) {
            this.digest.update(byArray, n, n2);
        }

        public byte[] generateSignature() throws CryptoException, DataLengthException {
            this.digest.doFinal(this.digBuf, 0);
            this.signer.update(this.digBuf, 0, this.digBuf.length);
            return this.signer.generateSignature();
        }

        public boolean verifySignature(byte[] byArray) {
            this.digest.doFinal(this.digBuf, 0);
            this.signer.update(this.digBuf, 0, this.digBuf.length);
            return this.signer.verifySignature(byArray);
        }

        public void reset() {
            Arrays.clear(this.digBuf);
            this.signer.reset();
            this.digest.reset();
        }
    }
}

