/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.shaded.jcajce.provider.digest;

import org.bouncycastle.shaded.asn1.nist.NISTObjectIdentifiers;
import org.bouncycastle.shaded.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.shaded.crypto.CipherKeyGenerator;
import org.bouncycastle.shaded.crypto.digests.SHA384Digest;
import org.bouncycastle.shaded.crypto.macs.HMac;
import org.bouncycastle.shaded.crypto.macs.OldHMac;
import org.bouncycastle.shaded.jcajce.provider.config.ConfigurableProvider;
import org.bouncycastle.shaded.jcajce.provider.digest.BCMessageDigest;
import org.bouncycastle.shaded.jcajce.provider.digest.DigestAlgorithmProvider;
import org.bouncycastle.shaded.jcajce.provider.symmetric.util.BaseKeyGenerator;
import org.bouncycastle.shaded.jcajce.provider.symmetric.util.BaseMac;

public class SHA384 {
    private SHA384() {
    }

    public static class Digest
    extends BCMessageDigest
    implements Cloneable {
        public Digest() {
            super(new SHA384Digest());
        }

        public Object clone() throws CloneNotSupportedException {
            Digest digest = (Digest)super.clone();
            digest.digest = new SHA384Digest((SHA384Digest)this.digest);
            return digest;
        }
    }

    public static class HashMac
    extends BaseMac {
        public HashMac() {
            super(new HMac(new SHA384Digest()));
        }
    }

    public static class KeyGenerator
    extends BaseKeyGenerator {
        public KeyGenerator() {
            super("HMACSHA384", 384, new CipherKeyGenerator());
        }
    }

    public static class Mappings
    extends DigestAlgorithmProvider {
        private static final String PREFIX = SHA384.class.getName();

        public void configure(ConfigurableProvider configurableProvider) {
            configurableProvider.addAlgorithm("MessageDigest.SHA-384", PREFIX + "$Digest");
            configurableProvider.addAlgorithm("Alg.Alias.MessageDigest.SHA384", "SHA-384");
            configurableProvider.addAlgorithm("Alg.Alias.MessageDigest." + NISTObjectIdentifiers.id_sha384, "SHA-384");
            configurableProvider.addAlgorithm("Mac.OLDHMACSHA384", PREFIX + "$OldSHA384");
            configurableProvider.addAlgorithm("Mac.PBEWITHHMACSHA384", PREFIX + "$HashMac");
            this.addHMACAlgorithm(configurableProvider, "SHA384", PREFIX + "$HashMac", PREFIX + "$KeyGenerator");
            this.addHMACAlias(configurableProvider, "SHA384", PKCSObjectIdentifiers.id_hmacWithSHA384);
        }
    }

    public static class OldSHA384
    extends BaseMac {
        public OldSHA384() {
            super(new OldHMac(new SHA384Digest()));
        }
    }
}

