/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.shaded.crypto.generators;

import java.security.SecureRandom;
import org.bouncycastle.shaded.crypto.AsymmetricCipherKeyPair;
import org.bouncycastle.shaded.crypto.AsymmetricCipherKeyPairGenerator;
import org.bouncycastle.shaded.crypto.KeyGenerationParameters;
import org.bouncycastle.shaded.crypto.params.Ed448PrivateKeyParameters;
import org.bouncycastle.shaded.crypto.params.Ed448PublicKeyParameters;

public class Ed448KeyPairGenerator
implements AsymmetricCipherKeyPairGenerator {
    private SecureRandom random;

    public void init(KeyGenerationParameters keyGenerationParameters) {
        this.random = keyGenerationParameters.getRandom();
    }

    public AsymmetricCipherKeyPair generateKeyPair() {
        Ed448PrivateKeyParameters ed448PrivateKeyParameters = new Ed448PrivateKeyParameters(this.random);
        Ed448PublicKeyParameters ed448PublicKeyParameters = ed448PrivateKeyParameters.generatePublicKey();
        return new AsymmetricCipherKeyPair(ed448PublicKeyParameters, ed448PrivateKeyParameters);
    }
}

