/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.shaded.bcpg;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import org.bouncycastle.shaded.bcpg.BCPGInputStream;
import org.bouncycastle.shaded.bcpg.BCPGOutputStream;
import org.bouncycastle.shaded.bcpg.ContainedPacket;
import org.bouncycastle.shaded.bcpg.PublicKeyAlgorithmTags;
import org.bouncycastle.shaded.bcpg.PublicKeyPacket;
import org.bouncycastle.shaded.bcpg.PublicSubkeyPacket;
import org.bouncycastle.shaded.bcpg.S2K;
import org.bouncycastle.shaded.bcpg.SecretSubkeyPacket;

public class SecretKeyPacket
extends ContainedPacket
implements PublicKeyAlgorithmTags {
    public static final int USAGE_NONE = 0;
    public static final int USAGE_CHECKSUM = 255;
    public static final int USAGE_SHA1 = 254;
    private PublicKeyPacket pubKeyPacket;
    private byte[] secKeyData;
    private int s2kUsage;
    private int encAlgorithm;
    private S2K s2k;
    private byte[] iv;

    SecretKeyPacket(BCPGInputStream bCPGInputStream) throws IOException {
        this.pubKeyPacket = this instanceof SecretSubkeyPacket ? new PublicSubkeyPacket(bCPGInputStream) : new PublicKeyPacket(bCPGInputStream);
        this.s2kUsage = bCPGInputStream.read();
        if (this.s2kUsage == 255 || this.s2kUsage == 254) {
            this.encAlgorithm = bCPGInputStream.read();
            this.s2k = new S2K(bCPGInputStream);
        } else {
            this.encAlgorithm = this.s2kUsage;
        }
        if ((this.s2k == null || this.s2k.getType() != 101 || this.s2k.getProtectionMode() != 1) && this.s2kUsage != 0) {
            this.iv = this.encAlgorithm < 7 ? new byte[8] : new byte[16];
            bCPGInputStream.readFully(this.iv, 0, this.iv.length);
        }
        this.secKeyData = bCPGInputStream.readAll();
    }

    public SecretKeyPacket(PublicKeyPacket publicKeyPacket, int n, S2K s2K, byte[] byArray, byte[] byArray2) {
        this.pubKeyPacket = publicKeyPacket;
        this.encAlgorithm = n;
        this.s2kUsage = n != 0 ? 255 : 0;
        this.s2k = s2K;
        this.iv = byArray;
        this.secKeyData = byArray2;
    }

    public SecretKeyPacket(PublicKeyPacket publicKeyPacket, int n, int n2, S2K s2K, byte[] byArray, byte[] byArray2) {
        this.pubKeyPacket = publicKeyPacket;
        this.encAlgorithm = n;
        this.s2kUsage = n2;
        this.s2k = s2K;
        this.iv = byArray;
        this.secKeyData = byArray2;
    }

    public int getEncAlgorithm() {
        return this.encAlgorithm;
    }

    public int getS2KUsage() {
        return this.s2kUsage;
    }

    public byte[] getIV() {
        return this.iv;
    }

    public S2K getS2K() {
        return this.s2k;
    }

    public PublicKeyPacket getPublicKeyPacket() {
        return this.pubKeyPacket;
    }

    public byte[] getSecretKeyData() {
        return this.secKeyData;
    }

    public byte[] getEncodedContents() throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        BCPGOutputStream bCPGOutputStream = new BCPGOutputStream(byteArrayOutputStream);
        bCPGOutputStream.write(this.pubKeyPacket.getEncodedContents());
        bCPGOutputStream.write(this.s2kUsage);
        if (this.s2kUsage == 255 || this.s2kUsage == 254) {
            bCPGOutputStream.write(this.encAlgorithm);
            bCPGOutputStream.writeObject(this.s2k);
        }
        if (this.iv != null) {
            bCPGOutputStream.write(this.iv);
        }
        if (this.secKeyData != null && this.secKeyData.length > 0) {
            bCPGOutputStream.write(this.secKeyData);
        }
        bCPGOutputStream.close();
        return byteArrayOutputStream.toByteArray();
    }

    public void encode(BCPGOutputStream bCPGOutputStream) throws IOException {
        bCPGOutputStream.writePacket(5, this.getEncodedContents());
    }
}

