/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.shaded.bcpg;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import org.bouncycastle.shaded.bcpg.BCPGInputStream;
import org.bouncycastle.shaded.bcpg.BCPGOutputStream;
import org.bouncycastle.shaded.bcpg.ContainedPacket;
import org.bouncycastle.shaded.bcpg.MPInteger;
import org.bouncycastle.shaded.bcpg.PublicKeyAlgorithmTags;
import org.bouncycastle.shaded.util.Arrays;
import org.bouncycastle.shaded.util.io.Streams;

public class PublicKeyEncSessionPacket
extends ContainedPacket
implements PublicKeyAlgorithmTags {
    private int version;
    private long keyID;
    private int algorithm;
    private byte[][] data;

    PublicKeyEncSessionPacket(BCPGInputStream bCPGInputStream) throws IOException {
        this.version = bCPGInputStream.read();
        this.keyID |= (long)bCPGInputStream.read() << 56;
        this.keyID |= (long)bCPGInputStream.read() << 48;
        this.keyID |= (long)bCPGInputStream.read() << 40;
        this.keyID |= (long)bCPGInputStream.read() << 32;
        this.keyID |= (long)bCPGInputStream.read() << 24;
        this.keyID |= (long)bCPGInputStream.read() << 16;
        this.keyID |= (long)bCPGInputStream.read() << 8;
        this.keyID |= (long)bCPGInputStream.read();
        this.algorithm = bCPGInputStream.read();
        switch (this.algorithm) {
            case 1: 
            case 2: {
                this.data = new byte[1][];
                this.data[0] = new MPInteger(bCPGInputStream).getEncoded();
                break;
            }
            case 16: 
            case 20: {
                this.data = new byte[2][];
                this.data[0] = new MPInteger(bCPGInputStream).getEncoded();
                this.data[1] = new MPInteger(bCPGInputStream).getEncoded();
                break;
            }
            case 18: {
                this.data = new byte[1][];
                this.data[0] = Streams.readAll(bCPGInputStream);
                break;
            }
            default: {
                throw new IOException("unknown PGP public key algorithm encountered");
            }
        }
    }

    public PublicKeyEncSessionPacket(long l, int n, byte[][] byArray) {
        this.version = 3;
        this.keyID = l;
        this.algorithm = n;
        this.data = new byte[byArray.length][];
        for (int i = 0; i != byArray.length; ++i) {
            this.data[i] = Arrays.clone(byArray[i]);
        }
    }

    public int getVersion() {
        return this.version;
    }

    public long getKeyID() {
        return this.keyID;
    }

    public int getAlgorithm() {
        return this.algorithm;
    }

    public byte[][] getEncSessionKey() {
        return this.data;
    }

    public void encode(BCPGOutputStream bCPGOutputStream) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        BCPGOutputStream bCPGOutputStream2 = new BCPGOutputStream(byteArrayOutputStream);
        bCPGOutputStream2.write(this.version);
        bCPGOutputStream2.write((byte)(this.keyID >> 56));
        bCPGOutputStream2.write((byte)(this.keyID >> 48));
        bCPGOutputStream2.write((byte)(this.keyID >> 40));
        bCPGOutputStream2.write((byte)(this.keyID >> 32));
        bCPGOutputStream2.write((byte)(this.keyID >> 24));
        bCPGOutputStream2.write((byte)(this.keyID >> 16));
        bCPGOutputStream2.write((byte)(this.keyID >> 8));
        bCPGOutputStream2.write((byte)this.keyID);
        bCPGOutputStream2.write(this.algorithm);
        for (int i = 0; i != this.data.length; ++i) {
            bCPGOutputStream2.write(this.data[i]);
        }
        bCPGOutputStream2.close();
        bCPGOutputStream.writePacket(1, byteArrayOutputStream.toByteArray());
    }
}

