/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.modules.cryptography.internal.xml.reference;

import com.mulesoft.modules.cryptography.api.xml.config.XmlSignDigestAlgorithm;
import com.mulesoft.modules.cryptography.internal.errors.CryptoErrors;
import com.mulesoft.modules.cryptography.internal.xml.impl.XmlKeyImpl;
import com.mulesoft.modules.cryptography.internal.xml.reference.DocumentWiseEnvelopedSignatureContextProvider;
import com.mulesoft.modules.cryptography.internal.xml.reference.QueryBasedEnvelopedSignatureContextProvider;
import com.mulesoft.modules.cryptography.internal.xml.reference.SignatureContextProvider;
import java.security.InvalidAlgorithmParameterException;
import java.security.NoSuchAlgorithmException;
import java.util.Collections;
import java.util.List;
import javax.xml.crypto.dsig.DigestMethod;
import javax.xml.crypto.dsig.Reference;
import javax.xml.crypto.dsig.Transform;
import javax.xml.crypto.dsig.XMLObject;
import javax.xml.crypto.dsig.spec.TransformParameterSpec;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.extension.api.error.ErrorTypeDefinition;
import org.mule.runtime.extension.api.exception.ModuleException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public abstract class EnvelopedSignatureContextProvider
implements SignatureContextProvider {
    private XmlSignDigestAlgorithm digestAlgorithm;
    protected Element referencedElement;
    protected Document document;
    protected String elementPath;

    public EnvelopedSignatureContextProvider(XmlSignDigestAlgorithm digestAlgorithm, Document document, String elementPath) {
        this.digestAlgorithm = digestAlgorithm;
        this.document = document;
        this.elementPath = elementPath;
    }

    @Override
    public Reference getReference() {
        try {
            this.referencedElement = this.getReferencedElement();
            DigestMethod digestMethod = XmlKeyImpl.fac.newDigestMethod(this.digestAlgorithm.getAlgorithm(), null);
            Transform transform = XmlKeyImpl.fac.newTransform("http://www.w3.org/2000/09/xmldsig#enveloped-signature", (TransformParameterSpec)null);
            return XmlKeyImpl.fac.newReference(this.getReferencedURI(), digestMethod, Collections.singletonList(transform), null, null);
        }
        catch (InvalidAlgorithmParameterException | NoSuchAlgorithmException e) {
            throw new ModuleException(I18nMessageFactory.createStaticMessage((String)"Error getting reference of element to sign"), (ErrorTypeDefinition)CryptoErrors.PARAMETERS, (Throwable)e);
        }
    }

    @Override
    public List<XMLObject> getReferencedObjects() {
        return null;
    }

    @Override
    public Node getSignatureParentNode() {
        return this.referencedElement;
    }

    protected abstract Element getReferencedElement();

    protected abstract String getReferencedURI();

    protected static SignatureContextProvider contextProviderForElementPath(XmlSignDigestAlgorithm digestAlgorithm, Document document, String elementPath) {
        if (elementPath == null) {
            return new DocumentWiseEnvelopedSignatureContextProvider(digestAlgorithm, document);
        }
        return new QueryBasedEnvelopedSignatureContextProvider(digestAlgorithm, document, elementPath);
    }
}

