/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.modules.cryptography.internal.pgp;

import com.mulesoft.modules.cryptography.internal.errors.CryptoErrors;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.io.IOUtils;
import org.bouncycastle.bcpg.ArmoredOutputStream;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.extension.api.error.ErrorTypeDefinition;
import org.mule.runtime.extension.api.exception.ModuleException;

public class PgpTransformer {
    public static InputStream binaryToArmored(InputStream content) {
        try {
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            ArmoredOutputStream armoredOutputStream = new ArmoredOutputStream((OutputStream)outputStream);
            try {
                IOUtils.copyLarge((InputStream)content, (OutputStream)armoredOutputStream);
            }
            finally {
                org.mule.runtime.core.api.util.IOUtils.closeQuietly((Closeable)outputStream);
                org.mule.runtime.core.api.util.IOUtils.closeQuietly((Closeable)armoredOutputStream);
            }
            return new ByteArrayInputStream(outputStream.toByteArray());
        }
        catch (Exception e) {
            throw new ModuleException(I18nMessageFactory.createStaticMessage((String)"Could not transform binary to armored"), (ErrorTypeDefinition)CryptoErrors.TRANSFORMATION, (Throwable)e);
        }
    }
}

