/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.modules.cryptography.internal.pgp;

import com.mulesoft.modules.cryptography.api.pgp.config.PgpEncryptionAlgorithm;
import com.mulesoft.modules.cryptography.api.pgp.config.PgpKeyInfo;
import com.mulesoft.modules.cryptography.internal.FipsUtils;
import com.mulesoft.modules.cryptography.internal.errors.CryptoErrors;
import com.mulesoft.modules.cryptography.internal.pgp.config.PgpConfiguration;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Date;
import java.util.Iterator;
import java.util.Optional;
import org.bouncycastle.openpgp.PGPCompressedData;
import org.bouncycastle.openpgp.PGPCompressedDataGenerator;
import org.bouncycastle.openpgp.PGPEncryptedDataGenerator;
import org.bouncycastle.openpgp.PGPEncryptedDataList;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPLiteralData;
import org.bouncycastle.openpgp.PGPLiteralDataGenerator;
import org.bouncycastle.openpgp.PGPOnePassSignature;
import org.bouncycastle.openpgp.PGPOnePassSignatureList;
import org.bouncycastle.openpgp.PGPPrivateKey;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.PGPPublicKeyEncryptedData;
import org.bouncycastle.openpgp.PGPSignature;
import org.bouncycastle.openpgp.PGPSignatureGenerator;
import org.bouncycastle.openpgp.PGPSignatureList;
import org.bouncycastle.openpgp.PGPSignatureSubpacketGenerator;
import org.bouncycastle.openpgp.PGPUtil;
import org.bouncycastle.openpgp.jcajce.JcaPGPObjectFactory;
import org.bouncycastle.openpgp.operator.PGPContentSignerBuilder;
import org.bouncycastle.openpgp.operator.PGPContentVerifierBuilderProvider;
import org.bouncycastle.openpgp.operator.PGPDataEncryptorBuilder;
import org.bouncycastle.openpgp.operator.PGPDigestCalculatorProvider;
import org.bouncycastle.openpgp.operator.PGPKeyEncryptionMethodGenerator;
import org.bouncycastle.openpgp.operator.bc.BcKeyFingerprintCalculator;
import org.bouncycastle.openpgp.operator.bc.BcPBESecretKeyDecryptorBuilder;
import org.bouncycastle.openpgp.operator.bc.BcPGPContentSignerBuilder;
import org.bouncycastle.openpgp.operator.bc.BcPGPContentVerifierBuilderProvider;
import org.bouncycastle.openpgp.operator.bc.BcPGPDigestCalculatorProvider;
import org.bouncycastle.openpgp.operator.bc.BcPublicKeyKeyEncryptionMethodGenerator;
import org.bouncycastle.openpgp.operator.jcajce.JcaPGPContentVerifierBuilderProvider;
import org.bouncycastle.openpgp.operator.jcajce.JcePGPDataEncryptorBuilder;
import org.bouncycastle.openpgp.operator.jcajce.JcePublicKeyDataDecryptorFactoryBuilder;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.core.api.util.IOUtils;
import org.mule.runtime.core.api.util.StringUtils;
import org.mule.runtime.extension.api.error.ErrorTypeDefinition;
import org.mule.runtime.extension.api.exception.ModuleException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PgpEncrypter {
    public static final BcKeyFingerprintCalculator KEY_FINGERPRINT_CALCULATOR = new BcKeyFingerprintCalculator();
    public static final BcPGPDigestCalculatorProvider PGP_DIGEST_CALCULATOR_PROVIDER = new BcPGPDigestCalculatorProvider();
    public static final BcPBESecretKeyDecryptorBuilder PBE_SECRET_KEY_DECRYPTOR_BUILDER = new BcPBESecretKeyDecryptorBuilder((PGPDigestCalculatorProvider)PGP_DIGEST_CALCULATOR_PROVIDER);
    private static final int BUFFER_SIZE = 65536;
    private final Logger LOGGER = LoggerFactory.getLogger(PgpEncrypter.class);
    private PgpConfiguration config;

    public static String formatKeyFingerprint(Long fingerprint) {
        return Long.toHexString(fingerprint).toUpperCase();
    }

    public PgpEncrypter(PgpConfiguration config) {
        this.config = config;
    }

    public InputStream encrypt(InputStream inputData, String fileName, PgpKeyInfo encryptKeyInfo, PgpEncryptionAlgorithm algorithm, boolean disableMDC) {
        return this.encrypt(inputData, fileName, encryptKeyInfo, algorithm, Optional.empty(), disableMDC);
    }

    public InputStream encrypt(InputStream inputData, String fileName, PgpKeyInfo encryptKeyInfo, PgpEncryptionAlgorithm algorithm, Optional<PgpKeyInfo> signKeyInfo, boolean disableMDC) {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        try {
            if (encryptKeyInfo.isSymmetric()) {
                throw new ModuleException(I18nMessageFactory.createStaticMessage((String)"Symmetric encryption with PGP is not implemented yet"), (ErrorTypeDefinition)CryptoErrors.ENCRYPTION);
            }
            PGPPublicKey encryptionKey = encryptKeyInfo.getPublicKey(this.config.getKeystore());
            JcePGPDataEncryptorBuilder encryptorBuilder = new JcePGPDataEncryptorBuilder(algorithm.getNumericId());
            encryptorBuilder.setWithIntegrityPacket(!disableMDC);
            PGPEncryptedDataGenerator encryptedDataGenerator = new PGPEncryptedDataGenerator((PGPDataEncryptorBuilder)encryptorBuilder, false);
            BcPublicKeyKeyEncryptionMethodGenerator methodGenerator = new BcPublicKeyKeyEncryptionMethodGenerator(encryptionKey);
            encryptedDataGenerator.addMethod((PGPKeyEncryptionMethodGenerator)methodGenerator);
            PGPCompressedDataGenerator compressedDataGenerator = new PGPCompressedDataGenerator(1);
            PGPLiteralDataGenerator literalDataGenerator = new PGPLiteralDataGenerator();
            try (OutputStream encryptorEntryPoint = encryptedDataGenerator.open((OutputStream)outputStream, new byte[65536]);
                 OutputStream compressorEntryPoint = compressedDataGenerator.open(encryptorEntryPoint, new byte[65536]);
                 SignatureGeneratorClosable signatureGeneratorDeferredTillClose = this.generateSignatureGeneratorClosable(signKeyInfo, compressorEntryPoint);
                 OutputStream literalGeneratorEntryPoint = literalDataGenerator.open(compressorEntryPoint, 'b', fileName, new Date(), new byte[65536]);
                 AutoCloseable inputClosable = () -> inputData.close();){
                int readBytesLength;
                byte[] buf = new byte[65536];
                while ((readBytesLength = inputData.read(buf)) > 0) {
                    literalGeneratorEntryPoint.write(buf, 0, readBytesLength);
                    if (!signatureGeneratorDeferredTillClose.isEnabled()) continue;
                    signatureGeneratorDeferredTillClose.getSignatureGenerator().update(buf, 0, readBytesLength);
                }
            }
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(outputStream.toByteArray());
            return byteArrayInputStream;
        }
        catch (ModuleException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ModuleException(I18nMessageFactory.createStaticMessage((String)"Could not encrypt with PGP"), (ErrorTypeDefinition)CryptoErrors.ENCRYPTION, (Throwable)e);
        }
        finally {
            IOUtils.closeQuietly((Closeable)outputStream);
        }
    }

    protected SignatureGeneratorClosable generateSignatureGeneratorClosable(Optional<PgpKeyInfo> signerKeyInfo, OutputStream compressorEntryPoint) throws PGPException, IOException {
        boolean enabled = signerKeyInfo.isPresent();
        PGPSignatureGenerator signatureGenerator = null;
        if (enabled) {
            PGPPrivateKey senderPrivateKey = signerKeyInfo.get().getPrivateKey(this.config.getKeystore());
            signatureGenerator = this.prepareSignatureGenerator(compressorEntryPoint, senderPrivateKey);
        }
        if (signatureGenerator != null) {
            return new SignatureGeneratorClosable(enabled, signatureGenerator, compressorEntryPoint);
        }
        return new NullSignatureGeneratorClosable();
    }

    private PGPSignatureGenerator prepareSignatureGenerator(OutputStream compressedOutputStream, PGPPrivateKey senderPrivateKey) throws PGPException, IOException {
        BcPGPContentSignerBuilder signerBuilder = new BcPGPContentSignerBuilder(senderPrivateKey.getPublicKeyPacket().getAlgorithm(), 2);
        PGPSignatureGenerator signatureGenerator = new PGPSignatureGenerator((PGPContentSignerBuilder)signerBuilder);
        signatureGenerator.init(0, senderPrivateKey);
        PGPSignatureSubpacketGenerator signatureSubpacketGenerator = new PGPSignatureSubpacketGenerator();
        signatureSubpacketGenerator.setSignerUserID(false, this.getUserIdFrom(senderPrivateKey.getKeyID()));
        signatureGenerator.setHashedSubpackets(signatureSubpacketGenerator.generate());
        signatureGenerator.generateOnePassVersion(false).encode(compressedOutputStream);
        return signatureGenerator;
    }

    private String getUserIdFrom(long keyId) {
        String retrievedFromFingerprintMapping = this.config.getKeystore().getPrincipalFromFingerprint(keyId);
        if (retrievedFromFingerprintMapping != null) {
            return retrievedFromFingerprintMapping;
        }
        return (String)this.config.getKeystore().getPublicKey(keyId).getUserIDs().next();
    }

    public InputStream decrypt(InputStream inputData, String fileName, boolean validateIfSignatureFound) {
        try {
            InputStream decodedInputStream = PGPUtil.getDecoderStream((InputStream)inputData);
            JcaPGPObjectFactory pgpF = new JcaPGPObjectFactory(decodedInputStream);
            Object pgpObject = pgpF.nextObject();
            if (pgpObject == null) {
                throw new PGPException("Invalid PGP message");
            }
            PGPEncryptedDataList enc = pgpObject instanceof PGPEncryptedDataList ? (PGPEncryptedDataList)pgpObject : (PGPEncryptedDataList)pgpF.nextObject();
            Iterator it = enc.getEncryptedDataObjects();
            PGPPublicKeyEncryptedData pbe = null;
            PGPPrivateKey privateKey = null;
            while (it.hasNext()) {
                pbe = (PGPPublicKeyEncryptedData)it.next();
                if (!this.config.getKeystore().hasPrivateKey(pbe.getKeyID())) continue;
                privateKey = this.config.getKeystore().decryptPrivateKey(pbe.getKeyID());
                break;
            }
            if (privateKey == null) {
                throw new ModuleException("No valid private key found", (ErrorTypeDefinition)CryptoErrors.MISSING_KEY);
            }
            JcePublicKeyDataDecryptorFactoryBuilder jcePublicKeyDataDecryptorFactoryBuilder = new JcePublicKeyDataDecryptorFactoryBuilder();
            if (!FipsUtils.isFipsEnabled()) {
                jcePublicKeyDataDecryptorFactoryBuilder.setProvider("BC");
            }
            InputStream clearStream = pbe.getDataStream(jcePublicKeyDataDecryptorFactoryBuilder.build(privateKey));
            JcaPGPObjectFactory pgpObjectFactory = new JcaPGPObjectFactory(clearStream);
            pgpObject = pgpObjectFactory.nextObject();
            PGPOnePassSignature onePassSignature = null;
            while (!(pgpObject instanceof PGPLiteralData)) {
                if (pgpObject instanceof PGPOnePassSignatureList) {
                    onePassSignature = ((PGPOnePassSignatureList)pgpObject).get(0);
                    pgpObject = pgpObjectFactory.nextObject();
                    continue;
                }
                if (pgpObject instanceof PGPCompressedData) {
                    PGPLiteralData pgpLiteralData;
                    PGPCompressedData cData = (PGPCompressedData)pgpObject;
                    pgpObjectFactory = new JcaPGPObjectFactory(cData.getDataStream());
                    pgpObject = pgpObjectFactory.nextObject();
                    if (!StringUtils.isBlank((String)fileName) && pgpObject instanceof PGPLiteralData && (pgpLiteralData = (PGPLiteralData)pgpObject).getFileName().equals(fileName)) continue;
                }
                throw new PGPException("input is not PGPLiteralData - type unknown.");
            }
            PGPLiteralData pgpLiteralData = (PGPLiteralData)pgpObject;
            InputStream literalDataStream = pgpLiteralData.getInputStream();
            if (onePassSignature != null && validateIfSignatureFound) {
                int len;
                this.LOGGER.debug("One pass signature found, and validation was requested. Starting validation procedure");
                onePassSignature.init((PGPContentVerifierBuilderProvider)new BcPGPContentVerifierBuilderProvider(), this.config.getKeystore().getPublicKey(onePassSignature.getKeyID()));
                ByteArrayOutputStream byteArrayTemporalStream = new ByteArrayOutputStream();
                byte[] buffer = new byte[1024];
                this.LOGGER.debug("About to do a pass over the literal decrypted data");
                while ((len = literalDataStream.read(buffer)) > -1) {
                    byteArrayTemporalStream.write(buffer, 0, len);
                    onePassSignature.update(buffer, 0, len);
                }
                byteArrayTemporalStream.flush();
                PGPSignatureList signatureList = (PGPSignatureList)pgpObjectFactory.nextObject();
                PGPSignature signature = signatureList.get(0);
                PGPPublicKey publicKey = this.config.getKeystore().getPublicKey(signature.getKeyID());
                JcaPGPContentVerifierBuilderProvider verifierBuilderProvider = new JcaPGPContentVerifierBuilderProvider();
                if (!FipsUtils.isFipsEnabled()) {
                    verifierBuilderProvider.setProvider("BC");
                }
                signature.init((PGPContentVerifierBuilderProvider)verifierBuilderProvider, publicKey);
                if (!onePassSignature.verify(signature)) {
                    this.LOGGER.error("Discovered signature verification failed!");
                    throw new ModuleException(I18nMessageFactory.createStaticMessage((String)"Could not verify signature of decrypted message"), (ErrorTypeDefinition)CryptoErrors.DECRYPTION);
                }
                return new ByteArrayInputStream(byteArrayTemporalStream.toByteArray());
            }
            return literalDataStream;
        }
        catch (ModuleException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ModuleException(I18nMessageFactory.createStaticMessage((String)"Could not decrypt PGP data"), (ErrorTypeDefinition)CryptoErrors.DECRYPTION, (Throwable)e);
        }
    }

    private class SignatureGeneratorClosable
    implements AutoCloseable {
        private final boolean enabled;
        private final PGPSignatureGenerator signatureGenerator;
        private final OutputStream compressorEntryPoint;

        private SignatureGeneratorClosable(boolean enabled, PGPSignatureGenerator signatureGenerator, OutputStream compressorEntryPoint) {
            this.enabled = enabled;
            this.signatureGenerator = signatureGenerator;
            this.compressorEntryPoint = compressorEntryPoint;
        }

        @Override
        public void close() throws Exception {
            if (this.enabled) {
                this.signatureGenerator.generate().encode(this.compressorEntryPoint);
            }
        }

        public boolean isEnabled() {
            return this.enabled;
        }

        public PGPSignatureGenerator getSignatureGenerator() {
            return this.signatureGenerator;
        }
    }

    private class NullSignatureGeneratorClosable
    extends SignatureGeneratorClosable {
        private NullSignatureGeneratorClosable() {
            super(false, null, null);
        }
    }
}

