/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.modules.cryptography.internal.jce.impl;

import com.mulesoft.modules.cryptography.internal.errors.CryptoErrors;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.io.IOUtils;
import org.mule.encryption.Encrypter;
import org.mule.encryption.exception.MuleEncryptionException;
import org.mule.encryption.exception.MuleInvalidAlgorithmConfigurationException;
import org.mule.encryption.exception.MuleInvalidKeyException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.extension.api.error.ErrorTypeDefinition;
import org.mule.runtime.extension.api.exception.ModuleException;

public abstract class JceKeyImpl {
    public abstract String sign(InputStream var1, String var2);

    public abstract boolean validate(InputStream var1, String var2, String var3);

    protected abstract Encrypter encrypter(String var1);

    public InputStream encrypt(InputStream inputStream, String algorithm) {
        try {
            return new ByteArrayInputStream(this.encrypter(algorithm).encrypt(IOUtils.toByteArray((InputStream)inputStream)));
        }
        catch (MuleEncryptionException e) {
            throw this.buildOperationException(e, 1);
        }
        catch (IOException e) {
            throw new ModuleException(I18nMessageFactory.createStaticMessage((String)"Unexpected error trying to read the input Stream"), (ErrorTypeDefinition)CryptoErrors.ENCRYPTION, (Throwable)e);
        }
    }

    public InputStream decrypt(InputStream inputStream, String algorithm) {
        try {
            return new ByteArrayInputStream(this.encrypter(algorithm).decrypt(IOUtils.toByteArray((InputStream)inputStream)));
        }
        catch (MuleEncryptionException e) {
            throw this.buildOperationException(e, 2);
        }
        catch (IOException e) {
            throw new ModuleException(I18nMessageFactory.createStaticMessage((String)"Unexpected error trying to read the input Stream"), (ErrorTypeDefinition)CryptoErrors.DECRYPTION, (Throwable)e);
        }
    }

    private ModuleException buildOperationException(MuleEncryptionException exception, int mode) {
        CryptoErrors errorType;
        try {
            throw exception;
        }
        catch (MuleInvalidAlgorithmConfigurationException e) {
            errorType = CryptoErrors.PARAMETERS;
        }
        catch (MuleInvalidKeyException e) {
            errorType = CryptoErrors.KEY;
        }
        catch (MuleEncryptionException e) {
            errorType = mode == 1 ? CryptoErrors.ENCRYPTION : CryptoErrors.DECRYPTION;
        }
        return new ModuleException(I18nMessageFactory.createStaticMessage((String)exception.getMessage()), (ErrorTypeDefinition)errorType, (Throwable)exception);
    }
}

