/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.flatfile.lexical.x12;

import com.mulesoft.flatfile.lexical.DelimiterWriter;
import com.mulesoft.flatfile.lexical.WriteException;
import com.mulesoft.flatfile.lexical.WriterBase;
import com.mulesoft.flatfile.lexical.x12.X12Constants;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.Map;

public class X12Writer
extends DelimiterWriter {
    public X12Writer(OutputStream os, Charset encoding, char datasep, char subsep, int repsep, char segterm, String segsep, int subst, X12Constants.CharacterRestriction chset) {
        super(os, encoding, datasep, subsep, -1, repsep, segterm, segsep, -1, -1, subst, '.', chset.flags());
    }

    public String convertEscape(char chr) throws WriteException {
        throw new WriteException("unsupported character in data " + chr);
    }

    private void writeInterchangeControlNumber(Map<String, Object> props) throws IOException {
        X12Constants.VALN9.write(X12Writer.getRequired((String)"ISA13", props), (WriterBase)this);
    }

    public void init(Map<String, Object> props) throws IOException {
        this.writer.write("ISA");
        this.writeDataSeparator();
        this.writeProperty("ISA01", props, "00", X12Constants.VALID2);
        this.writeProperty("ISA02", props, "", X12Constants.VALAN10);
        this.writeProperty("ISA03", props, "00", X12Constants.VALID2);
        this.writeProperty("ISA04", props, "", X12Constants.VALAN10);
        this.writeProperty("ISA05", props, "00", X12Constants.VALID2);
        this.writeProperty("ISA06", props, null, X12Constants.VALAN15);
        this.writeProperty("ISA07", props, "00", X12Constants.VALID2);
        this.writeProperty("ISA08", props, null, X12Constants.VALAN15);
        Calendar calendar = (Calendar)props.get("ISA09");
        if (calendar == null) {
            calendar = new GregorianCalendar();
        }
        X12Constants.VALDT6.write((Object)calendar, (WriterBase)this);
        this.writeDataSeparator();
        Integer time = (Integer)props.get("ISA10");
        int millis = time == null ? (calendar.get(11) * 60 + calendar.get(12)) * 60 * 1000 : time;
        X12Constants.VALTM4.write((Object)millis, (WriterBase)this);
        this.writeDataSeparator();
        Object version = X12Writer.getRequired((String)"ISA12", props);
        if (!(version instanceof String)) {
            throw new WriteException("expected String value for property 'ISA12'");
        }
        if ("00402".compareTo(version.toString()) <= 0) {
            this.writer.write(this.repetitionSeparator > 0 ? this.repetitionSeparator : 85);
        } else {
            this.writer.write(85);
        }
        this.writeDataSeparator();
        X12Constants.VALID5.write((Object)version.toString(), (WriterBase)this);
        this.writeDataSeparator();
        this.writeInterchangeControlNumber(props);
        this.writeDataSeparator();
        this.writeProperty("ISA14", props, "1", X12Constants.VALID1);
        this.writeProperty("ISA15", props, "P", X12Constants.VALID1);
        this.writeComponentSeparator();
        this.writeSegmentTerminator();
        this.groupCount = 0;
    }

    public void term(Map<String, Object> props) throws IOException {
        this.writeToken("IEA");
        this.writeDataSeparator();
        X12Constants.VALN1_5.write((Object)this.groupCount, (WriterBase)this);
        this.writeDataSeparator();
        this.writeInterchangeControlNumber(props);
        this.writeSegmentTerminator();
    }
}

