/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connector.googlepubsub.internal.metadata.avro;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import org.apache.avro.Schema;
import org.mule.metadata.api.TypeLoader;
import org.mule.metadata.api.annotation.EnumAnnotation;
import org.mule.metadata.api.annotation.TypeAnnotation;
import org.mule.metadata.api.builder.BaseTypeBuilder;
import org.mule.metadata.api.builder.ObjectTypeBuilder;
import org.mule.metadata.api.builder.TypeBuilder;
import org.mule.metadata.api.builder.UnionTypeBuilder;
import org.mule.metadata.api.model.MetadataFormat;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.utils.MetadataTypeUtils;
import org.mule.runtime.extension.api.declaration.type.annotation.DefaultImplementingTypeAnnotation;

public class AvroTypeLoader
implements TypeLoader {
    private static final String PROPERTY_DEFAULT = "default";
    private static final MetadataFormat AVRO = new MetadataFormat("Avro", "json", new String[]{"application/json"});
    private final Schema schema;
    private final Map<String, TypeBuilder<?>> definedTypes;

    public AvroTypeLoader(String schema) {
        this.schema = new Schema.Parser().parse(schema);
        this.definedTypes = new HashMap();
    }

    public Optional<MetadataType> load(String identifier) {
        return this.load(identifier, null);
    }

    public Optional<MetadataType> load(String typeIdentifier, String typeAlias) {
        this.definedTypes.clear();
        BaseTypeBuilder builder = BaseTypeBuilder.create((MetadataFormat)AVRO);
        TypeBuilder<?> typeBuilder = this.resolveType(this.schema, builder, null);
        MetadataTypeUtils.addTypeAlias(typeBuilder, (String)typeAlias);
        return Optional.of(typeBuilder.build());
    }

    private TypeBuilder<?> resolveRecursiveTypes(Schema schema, Supplier<TypeBuilder<?>> compute) {
        if (this.definedTypes.containsKey(schema.getName())) {
            return this.definedTypes.get(schema.getName());
        }
        return compute.get();
    }

    private TypeBuilder<?> resolveType(Schema schema, BaseTypeBuilder builder, String defaultValue) {
        switch (schema.getType()) {
            case RECORD: {
                ObjectTypeBuilder newObject = builder.objectType().id(schema.getName()).label(schema.getFullName()).description(schema.getDoc());
                this.definedTypes.put(schema.getName(), (TypeBuilder<?>)newObject);
                schema.getFields().forEach(f -> newObject.addField().key(f.name()).label(f.name()).description(f.doc()).value(this.resolveRecursiveTypes(f.schema(), () -> this.resolveType(f.schema(), builder, String.valueOf(f.defaultVal())))).required(!f.hasDefaultValue()));
                return newObject;
            }
            case MAP: {
                return builder.objectType().with((TypeAnnotation)new DefaultImplementingTypeAnnotation(this.resolveRecursiveTypes(schema.getValueType(), () -> this.resolveType(schema.getValueType(), builder, String.valueOf(schema.getObjectProp(PROPERTY_DEFAULT)))).build())).label(schema.getFullName()).description(schema.getDoc());
            }
            case ARRAY: {
                return builder.arrayType().of(this.resolveRecursiveTypes(schema.getElementType(), () -> this.resolveType(schema.getElementType(), builder, String.valueOf(schema.getObjectProp(PROPERTY_DEFAULT)))));
            }
            case UNION: {
                UnionTypeBuilder unionType = builder.unionType();
                schema.getTypes().stream().map(t -> {
                    if (t.getType() == Schema.Type.NULL) {
                        return this.resolveType((Schema)t, builder, null);
                    }
                    ObjectTypeBuilder obj = builder.objectType();
                    obj.addField().key(t.getName()).label(t.getFullName()).value(this.resolveRecursiveTypes((Schema)t, () -> this.resolveType((Schema)t, builder, String.valueOf(schema.getObjectProp(PROPERTY_DEFAULT))))).required(true);
                    return obj;
                }).forEach(arg_0 -> ((UnionTypeBuilder)unionType).of(arg_0));
                return unionType;
            }
            case ENUM: {
                return builder.stringType().id(schema.getName()).with((TypeAnnotation)new EnumAnnotation(schema.getEnumSymbols().toArray())).defaultValue(defaultValue);
            }
            case FIXED: {
                return builder.stringType().length(Integer.valueOf(schema.getFixedSize())).defaultValue(defaultValue);
            }
            case STRING: {
                return builder.stringType().defaultValue(defaultValue);
            }
            case BYTES: {
                return builder.binaryType();
            }
            case LONG: 
            case INT: {
                return builder.numberType().integer().defaultValue(defaultValue);
            }
            case DOUBLE: 
            case FLOAT: {
                return builder.numberType().defaultValue(defaultValue);
            }
            case BOOLEAN: {
                return builder.booleanType().defaultValue(defaultValue);
            }
            case NULL: {
                return builder.nullType();
            }
        }
        return builder.anyType();
    }
}

