/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connector.googlepubsub.internal.metadata;

import com.google.pubsub.v1.Schema;
import com.google.pubsub.v1.Topic;
import com.mulesoft.connector.googlepubsub.internal.connection.PubSubConnection;
import com.mulesoft.connector.googlepubsub.internal.metadata.avro.AvroTypeLoader;
import org.mule.metadata.api.builder.BaseTypeBuilder;
import org.mule.metadata.api.model.MetadataFormat;
import org.mule.metadata.api.model.MetadataType;
import org.mule.runtime.api.connection.ConnectionException;
import org.mule.runtime.api.metadata.MetadataContext;
import org.mule.runtime.api.metadata.MetadataResolvingException;
import org.mule.runtime.api.metadata.resolving.FailureCode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GenericTopicBasedMetadataResolver {
    private static final Logger LOGGER = LoggerFactory.getLogger(GenericTopicBasedMetadataResolver.class);

    public PubSubConnection getConnection(MetadataContext context) throws ConnectionException, MetadataResolvingException {
        return (PubSubConnection)context.getConnection().orElseThrow(() -> new MetadataResolvingException("A connection is required to resolve Metadata but none was provided", FailureCode.INVALID_CONFIGURATION));
    }

    public MetadataType resolveMetadata(PubSubConnection connection, Topic topic) throws MetadataResolvingException {
        try {
            if (topic.hasSchemaSettings()) {
                Schema schema = connection.getSchema(topic.getSchemaSettings().getSchema());
                switch (schema.getType()) {
                    case AVRO: {
                        return new AvroTypeLoader(schema.getDefinition()).load(null).orElseThrow(() -> new MetadataResolvingException("Failed to retrieve schema!", FailureCode.INVALID_CONFIGURATION));
                    }
                }
                throw new MetadataResolvingException(String.format("Unsupported schema '%s'", schema.getType()), FailureCode.INVALID_CONFIGURATION);
            }
            LOGGER.warn("topic '{}' doesn't have a schema attached, metadata resolution is skipped.", (Object)topic.getName());
            return BaseTypeBuilder.create((MetadataFormat)MetadataFormat.JSON).anyType().build();
        }
        catch (Exception e) {
            throw new MetadataResolvingException("Failed to retrieve schema!", FailureCode.INVALID_CONFIGURATION, (Throwable)e);
        }
    }
}

