/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connector.googlepubsub.internal.connection;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.google.api.core.ApiFuture;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.FixedCredentialsProvider;
import com.google.api.gax.rpc.InvalidArgumentException;
import com.google.cloud.pubsub.v1.stub.GrpcPublisherStub;
import com.google.cloud.pubsub.v1.stub.GrpcSchemaServiceStub;
import com.google.cloud.pubsub.v1.stub.GrpcSubscriberStub;
import com.google.cloud.pubsub.v1.stub.PublisherStub;
import com.google.cloud.pubsub.v1.stub.PublisherStubSettings;
import com.google.cloud.pubsub.v1.stub.SchemaServiceStub;
import com.google.cloud.pubsub.v1.stub.SchemaServiceStubSettings;
import com.google.cloud.pubsub.v1.stub.SubscriberStub;
import com.google.cloud.pubsub.v1.stub.SubscriberStubSettings;
import com.google.iam.v1.TestIamPermissionsRequest;
import com.google.protobuf.ByteString;
import com.google.protobuf.FieldMask;
import com.google.protobuf.Timestamp;
import com.google.pubsub.v1.CreateSnapshotRequest;
import com.google.pubsub.v1.DeleteSnapshotRequest;
import com.google.pubsub.v1.GetSchemaRequest;
import com.google.pubsub.v1.GetSnapshotRequest;
import com.google.pubsub.v1.GetSubscriptionRequest;
import com.google.pubsub.v1.GetTopicRequest;
import com.google.pubsub.v1.ListSnapshotsRequest;
import com.google.pubsub.v1.ListSnapshotsResponse;
import com.google.pubsub.v1.ListTopicSnapshotsRequest;
import com.google.pubsub.v1.ListTopicSnapshotsResponse;
import com.google.pubsub.v1.ListTopicSubscriptionsRequest;
import com.google.pubsub.v1.ListTopicSubscriptionsResponse;
import com.google.pubsub.v1.ListTopicsRequest;
import com.google.pubsub.v1.ListTopicsResponse;
import com.google.pubsub.v1.PublishRequest;
import com.google.pubsub.v1.PublishResponse;
import com.google.pubsub.v1.Schema;
import com.google.pubsub.v1.SchemaView;
import com.google.pubsub.v1.SeekRequest;
import com.google.pubsub.v1.Snapshot;
import com.google.pubsub.v1.Subscription;
import com.google.pubsub.v1.Topic;
import com.google.pubsub.v1.UpdateSnapshotRequest;
import com.mulesoft.connectors.commons.template.connection.ConnectorConnection;
import java.io.IOException;
import java.io.InputStream;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.scheduler.Scheduler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PubSubConnection
implements ConnectorConnection {
    private static final ObjectMapper mapper = new ObjectMapper().registerModule((Module)new JavaTimeModule()).configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false).configure(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS, false);
    private static final Logger logger = LoggerFactory.getLogger(PubSubConnection.class);
    private final PublisherStub publisherStub;
    private final SubscriberStub subscriberStub;
    private final SchemaServiceStub schemaServiceStub;
    private final FixedCredentialsProvider credentialsProvider;
    private final Scheduler ioScheduler;

    public PubSubConnection(PublisherStubSettings pubSettings, SubscriberStubSettings subSettings, FixedCredentialsProvider credentialsProvider, Scheduler scheduler) throws IOException {
        this.subscriberStub = GrpcSubscriberStub.create((SubscriberStubSettings)subSettings);
        this.publisherStub = GrpcPublisherStub.create((PublisherStubSettings)pubSettings);
        this.schemaServiceStub = GrpcSchemaServiceStub.create((SchemaServiceStubSettings)((SchemaServiceStubSettings.Builder)SchemaServiceStubSettings.newBuilder().setCredentialsProvider((CredentialsProvider)credentialsProvider)).build());
        this.credentialsProvider = credentialsProvider;
        this.ioScheduler = scheduler;
    }

    public com.mulesoft.connector.googlepubsub.api.model.Snapshot createSnapshot(CreateSnapshotRequest createSnapshotRequest) {
        return PubSubConnection.fromPubSubSnapshot((Snapshot)this.subscriberStub.createSnapshotCallable().call((Object)createSnapshotRequest));
    }

    public com.mulesoft.connector.googlepubsub.api.model.Snapshot patchSnapshot(InputStream snapshotRequest, String updateMask) throws IOException {
        com.mulesoft.connector.googlepubsub.api.model.Snapshot apiSnapshot = (com.mulesoft.connector.googlepubsub.api.model.Snapshot)mapper.readValue(snapshotRequest, com.mulesoft.connector.googlepubsub.api.model.Snapshot.class);
        return PubSubConnection.fromPubSubSnapshot((Snapshot)this.subscriberStub.updateSnapshotCallable().call((Object)UpdateSnapshotRequest.newBuilder().setSnapshot(Snapshot.newBuilder().setName(apiSnapshot.getName()).setExpireTime(Timestamp.newBuilder().setSeconds(apiSnapshot.getExpireTime().toEpochSecond(ZoneOffset.UTC)).build()).setTopic(apiSnapshot.getTopic()).putAllLabels(apiSnapshot.getLabels()).build()).setUpdateMask(FieldMask.newBuilder().addAllPaths(Arrays.asList(updateMask.split(","))).build()).build()));
    }

    public void deleteSnapshot(DeleteSnapshotRequest deleteSnapshotRequest) {
        this.subscriberStub.deleteSnapshotCallable().call((Object)deleteSnapshotRequest);
    }

    public com.mulesoft.connector.googlepubsub.api.model.Snapshot getSnapshot(GetSnapshotRequest getSnapshotRequest) {
        return PubSubConnection.fromPubSubSnapshot((Snapshot)this.subscriberStub.getSnapshotCallable().call((Object)getSnapshotRequest));
    }

    public ListSnapshotsResponse getSnapshotsListResponse(ListSnapshotsRequest listSnapshotsRequest) {
        return (ListSnapshotsResponse)this.subscriberStub.listSnapshotsCallable().call((Object)listSnapshotsRequest);
    }

    public ApiFuture<PublishResponse> publishMessage(PublishRequest publishRequest) {
        return this.publisherStub.publishCallable().futureCall((Object)publishRequest);
    }

    public void seekMessages(SeekRequest seekRequest) {
        this.subscriberStub.seekCallable().call((Object)seekRequest);
    }

    public Topic getTopic(String topicId) {
        return (Topic)this.publisherStub.getTopicCallable().call((Object)GetTopicRequest.newBuilder().setTopic(topicId).build());
    }

    public Topic getTopic(String projectId, String topicName) {
        return this.getTopic(String.format("projects/%s/topics/%s", projectId, topicName));
    }

    public Subscription getSubscription(String subscriptionId) {
        return (Subscription)this.subscriberStub.getSubscriptionCallable().call((Object)GetSubscriptionRequest.newBuilder().setSubscription(subscriptionId).build());
    }

    public Subscription getSubscription(String projectId, String subscriptionName) {
        return this.getSubscription(String.format("projects/%s/subscriptions/%s", projectId, subscriptionName));
    }

    public Schema getSchema(String schema) {
        return (Schema)this.schemaServiceStub.getSchemaCallable().call((Object)GetSchemaRequest.newBuilder().setName(schema).setView(SchemaView.FULL).build());
    }

    public List<Topic> listTopics(String projectId) {
        return ((ListTopicsResponse)this.publisherStub.listTopicsCallable().call((Object)ListTopicsRequest.newBuilder().setProject(String.format("projects/%s", projectId)).build())).getTopicsList();
    }

    public List<String> listSnapshots(String topic) {
        return ((ListTopicSnapshotsResponse)this.publisherStub.listTopicSnapshotsCallable().call((Object)ListTopicSnapshotsRequest.newBuilder().setTopic(topic).build())).getSnapshotsList().asByteStringList().stream().map(ByteString::toStringUtf8).collect(Collectors.toList());
    }

    public List<String> listSubscriptions(String topic) {
        return ((ListTopicSubscriptionsResponse)this.publisherStub.listTopicSubscriptionsCallable().call((Object)ListTopicSubscriptionsRequest.newBuilder().setTopic(topic).build())).getSubscriptionsList().asByteStringList().stream().map(ByteString::toStringUtf8).collect(Collectors.toList());
    }

    public void disconnect() {
        this.publisherStub.shutdown();
        this.subscriberStub.shutdown();
        this.schemaServiceStub.shutdown();
    }

    public void validate() {
        try {
            this.publisherStub.testIamPermissionsCallable().call((Object)TestIamPermissionsRequest.newBuilder().setResource("project/test/topic/test").build());
            this.subscriberStub.testIamPermissionsCallable().call((Object)TestIamPermissionsRequest.newBuilder().setResource("project/test/subscription/test").build());
            logger.debug("Connection validated successfully");
        }
        catch (InvalidArgumentException e) {
            logger.debug("Exception expected, connection valid, resources won't be found (test values used)");
        }
        catch (Exception e) {
            throw new MuleRuntimeException(e.getCause());
        }
    }

    public CredentialsProvider getCredentialsProvider() {
        return this.credentialsProvider;
    }

    public static com.mulesoft.connector.googlepubsub.api.model.Snapshot fromPubSubSnapshot(Snapshot pubSubSnapshot) {
        return new com.mulesoft.connector.googlepubsub.api.model.Snapshot(pubSubSnapshot.getName(), pubSubSnapshot.getTopic(), LocalDateTime.ofEpochSecond(pubSubSnapshot.getExpireTime().getSeconds(), 0, ZoneOffset.UTC), pubSubSnapshot.getLabelsMap());
    }

    public Scheduler getIoScheduler() {
        return this.ioScheduler;
    }
}

