/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectors.google.bigquery.internal.util;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.mulesoft.connectors.google.bigquery.api.param.HttpPagedResponseAttributes;
import com.mulesoft.connectors.google.bigquery.internal.config.RestConfiguration;
import java.io.InputStream;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.mule.runtime.api.metadata.MediaType;
import org.mule.runtime.extension.api.runtime.operation.Result;

public final class RestSdkUtils {
    private RestSdkUtils() {
    }

    public static List<Result<String, HttpPagedResponseAttributes>> toListResult(RestConfiguration config, Result<InputStream, HttpPagedResponseAttributes> pageResult, Optional<JsonNode> pageElements) {
        ArrayList<Result<String, HttpPagedResponseAttributes>> typedValues = new ArrayList<Result<String, HttpPagedResponseAttributes>>();
        if (pageElements.isPresent()) {
            pageElements.get().forEach(row -> {
                try {
                    typedValues.add(Result.builder().output((Object)config.getObjectMapper().writeValueAsString(row)).mediaType(pageResult.getMediaType().orElse(MediaType.APPLICATION_JSON)).attributes(pageResult.getAttributes().orElseThrow(() -> new NullPointerException("Couldn't get the attributes for the result."))).build());
                }
                catch (JsonProcessingException e) {
                    e.printStackTrace();
                }
            });
        }
        return typedValues;
    }

    public static String stringValue(Object o) {
        if (o == null) {
            return null;
        }
        if (o instanceof String) {
            return (String)o;
        }
        if (o instanceof Integer || o instanceof Long || o instanceof Double) {
            NumberFormat numberFormat = NumberFormat.getInstance();
            numberFormat.setMaximumFractionDigits(Integer.MAX_VALUE);
            numberFormat.setGroupingUsed(false);
            return numberFormat.format(o);
        }
        return String.valueOf(o);
    }
}

