/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectors.google.bigquery.internal.util;

import com.mulesoft.connectors.google.bigquery.api.param.StreamingType;
import com.mulesoft.connectors.google.bigquery.internal.params.MultimapQueryParamFormatter;
import com.mulesoft.connectors.google.bigquery.internal.params.QueryParamFormatter;
import com.mulesoft.connectors.google.bigquery.internal.params.RequestParameters;
import com.mulesoft.connectors.google.bigquery.internal.util.RestSdkUtils;
import java.io.InputStream;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.mule.runtime.api.metadata.MediaType;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.api.util.MultiMap;
import org.mule.runtime.core.api.util.IOUtils;
import org.mule.runtime.http.api.HttpConstants;
import org.mule.runtime.http.api.domain.CaseInsensitiveMultiMap;
import org.mule.runtime.http.api.domain.entity.ByteArrayHttpEntity;
import org.mule.runtime.http.api.domain.entity.HttpEntity;
import org.mule.runtime.http.api.domain.entity.InputStreamHttpEntity;
import org.mule.runtime.http.api.domain.message.request.HttpRequest;
import org.mule.runtime.http.api.domain.message.request.HttpRequestBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RestRequestBuilder {
    private static final Logger LOGGER = LoggerFactory.getLogger(RestRequestBuilder.class);
    public static final String CONTENT_LENGTH = "Content-Length";
    public static final String TRANSFER_ENCODING = "Transfer-Encoding";
    public static final String CHUNKED = "chunked";
    private final String baseUri;
    private String path;
    private final HttpConstants.Method method;
    private String fullUri;
    private final MultiMap<String, String> headers = new CaseInsensitiveMultiMap(false);
    private final MultiMap<String, String> queryParams = new MultiMap();
    private final MultiMap<String, String> uriParams = new MultiMap();
    private TypedValue<InputStream> body = null;
    private StreamingType streamingType = StreamingType.AUTO;
    private QueryParamFormat queryParamFormat = QueryParamFormat.MULTIMAP;

    public RestRequestBuilder(String baseUri, String path, HttpConstants.Method method) {
        this(baseUri, path, method, null);
    }

    public RestRequestBuilder(String baseUri, String path, HttpConstants.Method method, RequestParameters requestParameters) {
        this.baseUri = baseUri;
        this.path = path;
        this.method = method;
        if (requestParameters != null) {
            this.headers.putAll(requestParameters.getCustomHeaders());
            this.queryParams.putAll(requestParameters.getCustomQueryParams());
        }
    }

    public String getUri() {
        return this.buildRequestUri();
    }

    public RestRequestBuilder addHeader(String key, Object value) {
        if (value != null) {
            this.headers.put((Object)key, (Object)RestSdkUtils.stringValue(value));
        }
        return this;
    }

    public RestRequestBuilder addHeaders(String key, List<?> values) {
        if (values != null && !values.isEmpty()) {
            values.forEach(value -> this.addHeader(key, value));
        }
        return this;
    }

    public MultiMap<String, String> getHeaders() {
        return this.headers.toImmutableMultiMap();
    }

    public RestRequestBuilder addQueryParam(String key, Object value) {
        if (value != null) {
            this.queryParams.put((Object)key, (Object)RestSdkUtils.stringValue(value));
        }
        return this;
    }

    public RestRequestBuilder addQueryParams(String key, List<?> values) {
        if (values != null && !values.isEmpty()) {
            values.forEach(value -> this.addQueryParam(key, value));
        }
        return this;
    }

    public RestRequestBuilder removeQueryParam(String key) {
        if (key != null) {
            this.queryParams.remove((Object)key);
        }
        return this;
    }

    public MultiMap<String, String> getQueryParams() {
        return this.queryParams.toImmutableMultiMap();
    }

    public RestRequestBuilder setQueryParamFormat(QueryParamFormat queryParamFormat) {
        this.queryParamFormat = queryParamFormat;
        return this;
    }

    public RestRequestBuilder setBody(TypedValue<InputStream> body, StreamingType streamingType) {
        this.body = body;
        this.streamingType = streamingType;
        return this;
    }

    private HttpEntity getStreamingConfiguredHttpEntity(TypedValue<InputStream> body, StreamingType streamingType) {
        if (body != null) {
            byte[] bytes = null;
            if (streamingType.equals((Object)StreamingType.ALWAYS)) {
                this.headers.remove((Object)CONTENT_LENGTH);
                this.headers.remove((Object)TRANSFER_ENCODING);
                this.headers.put((Object)TRANSFER_ENCODING, (Object)CHUNKED);
            } else if (streamingType.equals((Object)StreamingType.NEVER)) {
                bytes = this.setNeverStreamingContentLength(body);
            } else {
                this.setAutoContentLengthHeader(body);
            }
            this.inferContentTypeFromBody(body);
            if (body.getValue() != null) {
                if (bytes != null) {
                    return new ByteArrayHttpEntity(bytes);
                }
                return new InputStreamHttpEntity((InputStream)body.getValue());
            }
        }
        return null;
    }

    private void inferContentTypeFromBody(TypedValue<InputStream> body) {
        MediaType mediaType;
        if (!this.headers.containsKey((Object)"Content-Type") && (mediaType = body.getDataType().getMediaType()) != null && !mediaType.getPrimaryType().equals("*")) {
            this.headers.put((Object)"Content-Type", (Object)mediaType.toRfcString());
        }
    }

    private byte[] setNeverStreamingContentLength(TypedValue<InputStream> body) {
        String customLength = (String)this.headers.get((Object)CONTENT_LENGTH);
        byte[] bytes = null;
        if (customLength == null) {
            if (body.getByteLength().isPresent()) {
                this.addHeader(CONTENT_LENGTH, body.getByteLength().getAsLong());
            } else if (body.getValue() != null) {
                bytes = IOUtils.toByteArray((InputStream)((InputStream)body.getValue()));
                this.addHeader(CONTENT_LENGTH, bytes.length);
            }
        }
        this.headers.remove((Object)TRANSFER_ENCODING);
        return bytes;
    }

    private void setAutoContentLengthHeader(TypedValue<InputStream> body) {
        String customLength = (String)this.headers.get((Object)CONTENT_LENGTH);
        boolean isChunked = CHUNKED.equals(this.headers.get((Object)TRANSFER_ENCODING));
        if (body.getByteLength().isPresent()) {
            boolean addHeader = true;
            String length = String.valueOf(body.getByteLength().getAsLong());
            if (customLength != null) {
                LOGGER.warn("Invoking URI {} with body of known length {}. However, a {} header with value {} was manually specified. Will proceed with the custom value.", new Object[]{this.getUri(), length, CONTENT_LENGTH, customLength});
                addHeader = false;
            }
            if (isChunked) {
                LOGGER.debug("Invoking URI {} with a manually set {}: {} header, even though body is of known length {}. Skipping automatic addition of {} header", new Object[]{this.getUri(), TRANSFER_ENCODING, CHUNKED, length, CONTENT_LENGTH});
                addHeader = false;
            }
            if (addHeader) {
                this.headers.put((Object)CONTENT_LENGTH, (Object)length);
            }
        } else if (customLength == null && !isChunked) {
            this.headers.put((Object)TRANSFER_ENCODING, (Object)CHUNKED);
        }
    }

    public HttpRequest build() {
        HttpEntity httpEntity = this.getStreamingConfiguredHttpEntity(this.body, this.streamingType);
        HttpRequestBuilder builder = (HttpRequestBuilder)HttpRequest.builder((boolean)true).uri(this.getUri()).method(this.method).queryParams(this.queryParamFormat.getFormatter().format(this.queryParams)).headers(this.headers);
        if (httpEntity != null) {
            builder.entity(httpEntity);
        }
        return builder.build();
    }

    private String buildRequestUri() {
        if (StringUtils.isNotBlank((CharSequence)this.fullUri)) {
            return this.fullUri;
        }
        String localPath = this.path;
        String localBaseUri = this.baseUri;
        boolean pathStartsWithSlash = localPath != null && localPath.startsWith("/");
        boolean baseEndsInSlash = localBaseUri.endsWith("/");
        if (pathStartsWithSlash && baseEndsInSlash) {
            localPath = localPath.substring(1);
        } else if (!pathStartsWithSlash && !baseEndsInSlash) {
            localBaseUri = localBaseUri + '/';
        }
        localPath = this.applyUriParameters(localPath);
        return localBaseUri + localPath;
    }

    private String applyUriParameters(String path) {
        if (path != null) {
            for (String key : this.uriParams.keySet()) {
                path = path.replace(String.format("{%s}", key), String.join((CharSequence)",", this.uriParams.getAll((Object)key)));
            }
        }
        return path;
    }

    public static enum QueryParamFormat {
        MULTIMAP(new MultimapQueryParamFormatter());

        private final QueryParamFormatter formatter;

        private QueryParamFormat(QueryParamFormatter formatter) {
            this.formatter = formatter;
        }

        public QueryParamFormatter getFormatter() {
            return this.formatter;
        }
    }
}

