/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectors.google.bigquery.internal.util;

import com.mulesoft.connectors.google.bigquery.internal.connection.ConfigurationOverrides;
import com.mulesoft.connectors.google.bigquery.internal.connection.RestConnection;
import com.mulesoft.connectors.google.bigquery.internal.params.NonEntityRequestParameters;
import com.mulesoft.connectors.google.bigquery.internal.util.RestRequestBuilder;
import java.io.InputStream;
import java.util.function.Function;
import java.util.regex.Pattern;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.http.api.HttpConstants;

public class RequestBuilderCreator {
    private static final Pattern BIGQUERY_PROJECT_ID_PATTERN = Pattern.compile("\\{projectId}");
    private static final RestRequestBuilder.QueryParamFormat QUERY_PARAM_FORMAT = RestRequestBuilder.QueryParamFormat.MULTIMAP;

    private RequestBuilderCreator() {
    }

    public static Function<RestConnection, RestRequestBuilder> queryRequestBuilderFunction(TypedValue<InputStream> queryValuesContent, NonEntityRequestParameters parameters, ConfigurationOverrides overrides) {
        return connection -> {
            RestRequestBuilder builder = new RestRequestBuilder(connection.getBaseUri(), RequestBuilderCreator.buildRequestPath("projects/{projectId}/queries", connection.getProjectId()), HttpConstants.Method.POST, parameters);
            builder.setBody(queryValuesContent, overrides.getStreamingType()).setQueryParamFormat(QUERY_PARAM_FORMAT).addHeader("accept", "application/json").addHeader("content-type", "application/json");
            return builder;
        };
    }

    private static String buildRequestPath(String mainData, String projectId) {
        return RequestBuilderCreator.replaceMatcher(mainData, BIGQUERY_PROJECT_ID_PATTERN, projectId);
    }

    private static String replaceMatcher(String mainData, Pattern pattern, String data) {
        return pattern.matcher(mainData).replaceAll(data);
    }
}

