/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectors.google.bigquery.internal.util;

import com.mulesoft.connectors.google.bigquery.internal.config.RestConfiguration;
import com.mulesoft.connectors.google.bigquery.internal.params.OnTableRowParameterGroup;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.time.LocalDateTime;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Optional;
import java.util.regex.Pattern;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.core.api.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueryHelper {
    private static final Logger logger = LoggerFactory.getLogger(QueryHelper.class);
    private static final String WATERMARK_FILTER = " WHERE {watermarkColumn} > {since}";
    private static final String ORDER_BY = " ORDER BY {watermarkColumn} ASC";
    private static final String SQL_SENTENCE_DECORATOR = "\"{sqlSentence};\"";
    private static final String PAYLOAD = "{\"query\": {sqlSentence}, \"useLegacySql\": false, \"maxResults\": {maxResults}}";
    public static final DateTimeFormatter TIMESTAMP_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss.SSSZZZ");
    public static final DateTimeFormatter DATE_TIME_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss.SSS");
    private final RestConfiguration config;
    private final int maximumRows;
    private String sqlSentence = "SELECT * FROM `{datasetName}.{tableName}`";
    private final String datasetName;
    private final String tableName;
    private final String watermarkColumn;

    public QueryHelper(RestConfiguration config, OnTableRowParameterGroup onTableRowParameterGroup, int maximumRows) {
        this.config = config;
        this.datasetName = onTableRowParameterGroup.getDatasetName();
        this.tableName = onTableRowParameterGroup.getTableName();
        this.watermarkColumn = onTableRowParameterGroup.getWatermarkColumn();
        this.maximumRows = maximumRows;
    }

    private void appendWatermarkInSqlSentence(String watermarkColumn, Serializable since) {
        String parsed = this.convertToParameterValue(since);
        parsed = WATERMARK_FILTER.replace("{since}", parsed);
        parsed = parsed.replace("{watermarkColumn}", watermarkColumn);
        this.sqlSentence = this.sqlSentence + parsed;
    }

    private String convertToParameterValue(Serializable value) {
        Optional<Object> quotedValue = Optional.empty();
        if (value instanceof String) {
            quotedValue = Optional.of(((String)((Object)value)).replace("'", "\\'"));
        } else if (value instanceof LocalDateTime) {
            quotedValue = Optional.of(((LocalDateTime)value).format(DATE_TIME_FORMATTER));
        } else if (value instanceof ZonedDateTime) {
            quotedValue = Optional.of(((ZonedDateTime)value).format(TIMESTAMP_FORMATTER));
        } else if (value instanceof Number) {
            return String.valueOf(value);
        }
        return quotedValue.map(v -> String.format("'%s'", v)).orElseThrow(() -> new MuleRuntimeException(I18nMessageFactory.createStaticMessage((String)"Invalid since value, expected one of Number, String, ZonedDateTime or LocalDateTime, but was ")));
    }

    private void setPayloadInSqlSentence(String sqlSentence) {
        this.sqlSentence = String.valueOf(this.replaceParameters("\\{sqlSentence}", PAYLOAD, sqlSentence));
    }

    private void setDatasetNameInSqlSentence(String datasetName) {
        this.sqlSentence = String.valueOf(this.replaceParameters("\\{datasetName}", this.sqlSentence, datasetName));
    }

    private void setTableNameInSqlSentence(String tableName) {
        this.sqlSentence = String.valueOf(this.replaceParameters("\\{tableName}", this.sqlSentence, tableName));
    }

    private void addSqlDecoratorsInSqlSentence(String sqlSentence) {
        this.sqlSentence = String.valueOf(this.replaceParameters("\\{sqlSentence}", SQL_SENTENCE_DECORATOR, sqlSentence));
    }

    private String replaceVariable(String stringToReplace, String variableName, String value) {
        return String.valueOf(this.replaceParameters("\\{" + variableName + "}", stringToReplace, value));
    }

    private StringBuilder replaceParameters(String regex, String matcherString, String replaceString) {
        return new StringBuilder(Pattern.compile(regex).matcher(matcherString).replaceAll(replaceString));
    }

    public String getSqlSentenceResult() {
        return this.sqlSentence;
    }

    public static TypedValue<InputStream> getTableSchemaInformationQuery(String datasetName, String tableName) {
        String sqlSentence = "{\"query\": \"SELECT column_name, data_type, description FROM `{datasetName}`.INFORMATION_SCHEMA.COLUMN_FIELD_PATHS WHERE table_name='{tableName}';\", \"useLegacySql\": false}";
        sqlSentence = sqlSentence.replace("{datasetName}", datasetName);
        sqlSentence = sqlSentence.replace("{tableName}", tableName);
        return QueryHelper.stringToInputStreamTypedValue(sqlSentence);
    }

    public static TypedValue<InputStream> getDatasetsQueryPayload(String projectId) {
        String sqlSentence = "{\"query\": \"SELECT schema_name FROM `{projectId}`.INFORMATION_SCHEMA.SCHEMATA;\", \"useLegacySql\": false}";
        sqlSentence = sqlSentence.replace("{projectId}", projectId);
        return QueryHelper.stringToInputStreamTypedValue(sqlSentence);
    }

    public TypedValue<InputStream> getRowsQuery(Optional<Serializable> since) {
        this.setDatasetNameInSqlSentence(this.datasetName);
        this.setTableNameInSqlSentence(this.tableName);
        if (!StringUtils.isBlank((String)this.watermarkColumn) && since.isPresent()) {
            this.appendWatermarkInSqlSentence(this.watermarkColumn, since.get());
            this.sqlSentence = this.sqlSentence + ORDER_BY.replace("{watermarkColumn}", this.watermarkColumn);
        }
        this.addSqlDecoratorsInSqlSentence(this.sqlSentence);
        this.setPayloadInSqlSentence(this.sqlSentence);
        this.sqlSentence = this.replaceVariable(this.sqlSentence, "maxResults", String.valueOf(this.maximumRows));
        return QueryHelper.stringToInputStreamTypedValue(this.getSqlSentenceResult());
    }

    private static TypedValue<InputStream> stringToInputStreamTypedValue(String sqlSentence) {
        logger.debug("Query = {}", (Object)sqlSentence);
        return new TypedValue((Object)new ByteArrayInputStream(sqlSentence.getBytes(StandardCharsets.UTF_8)), DataType.JSON_STRING);
    }
}

