/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectors.google.bigquery.internal.util;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.google.gson.Gson;
import com.mulesoft.connectors.google.bigquery.api.param.HttpResponseAttributes;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.mule.runtime.api.metadata.MediaType;
import org.mule.runtime.extension.api.runtime.operation.Result;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ObjectMapperTransformations {
    private static final Logger logger = LoggerFactory.getLogger(ObjectMapperTransformations.class);

    private ObjectMapperTransformations() {
    }

    private static List<String> getSchemaFieldNames(JsonNode responseMap) {
        JsonNode fieldsSchema = responseMap.get("schema").get("fields");
        ArrayList<String> fieldNames = new ArrayList<String>();
        fieldsSchema.forEach(field -> fieldNames.add(field.get("name").asText()));
        logger.debug("Schema fields name = {}", fieldNames);
        return fieldNames;
    }

    public static List<Map<String, Object>> replaceResponseKeysForSchemaFieldNames(JsonNode responseMap) {
        List<String> schemaFieldNames = ObjectMapperTransformations.getSchemaFieldNames(responseMap);
        ArrayList<Map<String, Object>> results = new ArrayList<Map<String, Object>>();
        if (responseMap.get("totalRows").asInt() == 0) {
            logger.debug("Could not parse response as the number of totalRows was 0");
            return results;
        }
        JsonNode rows = responseMap.get("rows");
        rows.forEach(row -> results.add(ObjectMapperTransformations.replaceResponseKeysWithSchemaFieldNames(schemaFieldNames, row)));
        logger.debug("Parsed rows = {}", results);
        return results;
    }

    public static List<Result<String, HttpResponseAttributes>> replaceResponseKeysForSchemaFieldNames(Result<InputStream, HttpResponseAttributes> rawResult, JsonNode pageRawResult, JsonNode rows) {
        if (pageRawResult.get("totalRows").asInt() == 0) {
            logger.debug("Could not parse response as the number of totalRows was 0");
            return Collections.emptyList();
        }
        ArrayList<Result<String, HttpResponseAttributes>> results = new ArrayList<Result<String, HttpResponseAttributes>>();
        List<String> schemaFieldNames = ObjectMapperTransformations.getSchemaFieldNames(pageRawResult);
        rows.forEach(row -> {
            Map<String, Object> rowMap = ObjectMapperTransformations.replaceResponseKeysWithSchemaFieldNames(schemaFieldNames, row);
            Result.Builder resultBuilder = Result.builder().output((Object)new Gson().toJson(rowMap)).mediaType(MediaType.APPLICATION_JSON);
            rawResult.getAttributes().ifPresent(arg_0 -> ((Result.Builder)resultBuilder).attributes(arg_0));
            rawResult.getAttributesMediaType().ifPresent(arg_0 -> ((Result.Builder)resultBuilder).attributesMediaType(arg_0));
            results.add(resultBuilder.build());
        });
        logger.debug("Parsed rows = {}", results);
        return results;
    }

    private static Map<String, Object> replaceResponseKeysWithSchemaFieldNames(List<String> schemaFieldNames, JsonNode row) {
        ArrayNode f = (ArrayNode)row.get("f");
        HashMap<String, Object> parsedRow = new HashMap<String, Object>();
        for (int i = 0; i < f.size(); ++i) {
            parsedRow.put(schemaFieldNames.get(i), f.get(i).get("v").asText());
        }
        return parsedRow;
    }
}

