/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectors.google.bigquery.internal.util;

import java.util.regex.Pattern;

public class BigQueryEndpoints {
    public static final String QUERIES_PATH_STRING_FORMAT = "%s/projects/{projectId}/queries";

    private BigQueryEndpoints() {
    }

    public static String getRequestPathForQueriesOperation(String baseUri, String projectId) {
        String requestPath = String.format(QUERIES_PATH_STRING_FORMAT, baseUri);
        return Pattern.compile("\\{projectId}").matcher(requestPath).replaceAll(projectId);
    }

    public static String getRequestPathForTablesOperation(String baseUri, String projectId, String datasetName) {
        String requestPath = String.format("%s/projects/{projectId}/datasets/{datasetId}/tables/", baseUri);
        return Pattern.compile("\\{projectId}").matcher(Pattern.compile("\\{datasetId}").matcher(requestPath).replaceAll(datasetName)).replaceAll(projectId);
    }
}

